/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.env;

import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.order.Ordered;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.annotation.Selector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@Endpoint(value="env")
public class EnvironmentEndpoint {
    public static final String NAME = "env";
    public static final String[] PROPERTY_NAMES_TO_MASK = new String[]{"password", "credential", "certificate", "key", "secret", "token"};
    private final Environment environment;
    private final List<Pattern> maskPatterns;

    public EnvironmentEndpoint(Environment environment) {
        this.environment = environment;
        this.maskPatterns = Arrays.stream(PROPERTY_NAMES_TO_MASK).map(s -> Pattern.compile(".*" + s + ".*", 2)).collect(Collectors.toList());
    }

    @Read
    public Map<String, Object> getEnvironmentInfo() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("activeEnvironments", this.environment.getActiveNames());
        result.put("packages", this.environment.getPackages());
        ArrayList propertySources = new ArrayList();
        this.environment.getPropertySources().stream().sorted(Comparator.comparing(Ordered::getOrder)).forEach(ps -> propertySources.add(this.buildPropertySourceInfo((PropertySource)ps)));
        result.put("propertySources", propertySources);
        return result;
    }

    @Read
    public Map<String, Object> getProperties(@Selector String propertySourceName) {
        return this.environment.getPropertySources().stream().filter(ps -> ps.getName().equals(propertySourceName)).findFirst().map(this::buildPropertySourceInfo).orElse(null);
    }

    private Map<String, Object> getAllProperties(PropertySource propertySource) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        propertySource.forEach(k -> properties.put((String)k, this.maskProperty((String)k, propertySource.get(k))));
        return properties;
    }

    private Map<String, Object> buildPropertySourceInfo(PropertySource propertySource) {
        LinkedHashMap<String, Object> propertySourceInfo = new LinkedHashMap<String, Object>();
        propertySourceInfo.put("name", propertySource.getName());
        propertySourceInfo.put("order", propertySource.getOrder());
        propertySourceInfo.put("convention", propertySource.getConvention().name());
        propertySourceInfo.put("properties", this.getAllProperties(propertySource));
        return propertySourceInfo;
    }

    private Object maskProperty(String key, Object value) {
        for (Pattern pattern : this.maskPatterns) {
            if (!pattern.matcher(key).matches()) continue;
            return "*****";
        }
        return value;
    }
}

