/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.web.router.MethodBasedRouteMatch;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.UriRoute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public interface UriRouteMatch<T, R>
extends UriMatchInfo,
MethodBasedRouteMatch<T, R> {
    public UriRoute getRoute();

    default public List<Argument> getRequiredArguments() {
        Map matchVariables = this.getVariableValues();
        Argument[] arguments = this.getArguments();
        ArrayList<Argument> actualArguments = new ArrayList<Argument>(arguments.length);
        Argument body = this.getBodyArgument().orElse(null);
        for (Argument argument : arguments) {
            if (matchVariables.containsKey(argument.getName())) continue;
            if (body != null && body.getName().equals(argument.getName())) {
                actualArguments.add(body);
                continue;
            }
            actualArguments.add(argument);
        }
        return actualArguments;
    }

    public HttpMethod getHttpMethod();

    public UriRouteMatch<T, R> fulfill(Map<String, Object> var1);

    public UriRouteMatch<T, R> decorate(Function<RouteMatch<R>, R> var1);
}

