/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router.version;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.http.HttpRequest;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.filter.FilteredRouter;
import io.micronaut.web.router.version.RouteVersionFilter;
import io.micronaut.web.router.version.RoutesVersioningConfiguration;
import io.micronaut.web.router.version.VersionRouteMatchFilter;
import java.util.function.Predicate;
import javax.inject.Singleton;

@Singleton
@Requirements(value={@Requires(property="micronaut.router.versioning.enabled", value="true"), @Requires(beans={RoutesVersioningConfiguration.class})})
public class VersionAwareRouterListener
implements BeanCreatedEventListener<Router> {
    private final VersionRouteMatchFilter routeVersionFilter;

    public VersionAwareRouterListener(VersionRouteMatchFilter filter) {
        this.routeVersionFilter = filter;
    }

    @Deprecated
    public VersionAwareRouterListener(final RouteVersionFilter filter) {
        this.routeVersionFilter = new VersionRouteMatchFilter(){

            @Override
            public <T, R> Predicate<UriRouteMatch<T, R>> filter(HttpRequest<?> request) {
                return filter.filter(request);
            }
        };
    }

    public Router onCreated(BeanCreatedEvent<Router> event) {
        return new FilteredRouter((Router)event.getBean(), this.routeVersionFilter);
    }
}

