/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.gcp;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.discovery.cloud.ComputeInstanceMetadata;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolver;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolverUtils;
import io.micronaut.discovery.cloud.NetworkInterface;
import io.micronaut.discovery.cloud.gcp.GoogleComputeInstanceMetadata;
import io.micronaut.discovery.cloud.gcp.GoogleComputeMetadataConfiguration;
import io.micronaut.discovery.cloud.gcp.GoogleComputeMetadataKeys;
import io.micronaut.discovery.cloud.gcp.GoogleComputeNetworkInterface;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(env={"gcp"})
public class GoogleComputeInstanceMetadataResolver
implements ComputeInstanceMetadataResolver {
    public static final String HEADER_METADATA_FLAVOR = "Metadata-Flavor";
    private static final Logger LOG = LoggerFactory.getLogger(GoogleComputeInstanceMetadataResolver.class);
    private final ObjectMapper objectMapper;
    private final GoogleComputeMetadataConfiguration configuration;
    private GoogleComputeInstanceMetadata cachedMetadata;

    @Inject
    public GoogleComputeInstanceMetadataResolver(ObjectMapper objectMapper, GoogleComputeMetadataConfiguration configuration) {
        this.objectMapper = objectMapper;
        this.configuration = configuration;
    }

    public GoogleComputeInstanceMetadataResolver() {
        this.objectMapper = new ObjectMapper();
        this.configuration = new GoogleComputeMetadataConfiguration();
    }

    @Override
    public Optional<ComputeInstanceMetadata> resolve(Environment environment) {
        GoogleComputeInstanceMetadata instanceMetadata;
        block23: {
            if (!this.configuration.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Resolving of Google Compute Instance metadata is disabled");
                }
                return Optional.empty();
            }
            if (this.cachedMetadata != null) {
                this.cachedMetadata.setCached(true);
                return Optional.of(this.cachedMetadata);
            }
            instanceMetadata = null;
            try {
                JsonNode projectResultJson;
                HashMap<String, String> requestProperties;
                int readTimeoutMs;
                int connectionTimeoutMs;
                block22: {
                    connectionTimeoutMs = (int)this.configuration.getConnectTimeout().toMillis();
                    readTimeoutMs = (int)this.configuration.getReadTimeout().toMillis();
                    requestProperties = new HashMap<String, String>();
                    requestProperties.put(HEADER_METADATA_FLAVOR, "Google");
                    projectResultJson = null;
                    try {
                        projectResultJson = ComputeInstanceMetadataResolverUtils.readMetadataUrl(new URL(this.configuration.getProjectMetadataUrl() + "?recursive=true"), connectionTimeoutMs, readTimeoutMs, this.objectMapper, requestProperties);
                    }
                    catch (MalformedURLException me) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Google compute project metadataUrl value is invalid!: " + this.configuration.getProjectMetadataUrl(), (Throwable)me);
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("No project metadata found at: " + this.configuration.getProjectMetadataUrl() + "?recursive=true", (Throwable)fnfe);
                        }
                    }
                    catch (IOException ioe) {
                        if (!LOG.isDebugEnabled()) break block22;
                        LOG.debug("Error connecting to" + this.configuration.getProjectMetadataUrl() + "?recursive=true reading project metadata. Not a Google environment?", (Throwable)ioe);
                    }
                }
                JsonNode instanceMetadataJson = ComputeInstanceMetadataResolverUtils.readMetadataUrl(new URL(this.configuration.getMetadataUrl() + "?recursive=true"), connectionTimeoutMs, readTimeoutMs, this.objectMapper, requestProperties);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read compute instance metadata from URL [{}]. Resulting JSON: {}", (Object)this.configuration.getMetadataUrl(), (Object)instanceMetadataJson);
                }
                if (environment.getActiveNames().contains("gae")) {
                    instanceMetadata = new GoogleComputeInstanceMetadata();
                    instanceMetadata.setInstanceId(System.getenv("GAE_INSTANCE"));
                    instanceMetadata.setAccount(System.getenv("GOOGLE_CLOUD_PROJECT"));
                }
                if (instanceMetadataJson != null) {
                    if (instanceMetadata == null) {
                        instanceMetadata = new GoogleComputeInstanceMetadata();
                    }
                    ComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.ID.getName()).ifPresent(instanceMetadata::setInstanceId);
                    if (projectResultJson != null) {
                        ComputeInstanceMetadataResolverUtils.stringValue(projectResultJson, GoogleComputeMetadataKeys.PROJECT_ID.getName()).ifPresent(instanceMetadata::setAccount);
                    } else {
                        ComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.PROJECT_ID.getName()).ifPresent(instanceMetadata::setAccount);
                    }
                    ComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.ZONE.getName()).ifPresent(instanceMetadata::setAvailabilityZone);
                    ComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.MACHINE_TYPE.getName()).ifPresent(instanceMetadata::setMachineType);
                    ComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.DESCRIPTION.getName()).ifPresent(instanceMetadata::setDescription);
                    ComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.IMAGE.getName()).ifPresent(instanceMetadata::setImageId);
                    ComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.HOSTNAME.getName()).ifPresent(instanceMetadata::setLocalHostname);
                    ComputeInstanceMetadataResolverUtils.stringValue(instanceMetadataJson, GoogleComputeMetadataKeys.NAME.getName()).ifPresent(instanceMetadata::setName);
                    JsonNode networkInterfaces = instanceMetadataJson.findValue(GoogleComputeMetadataKeys.NETWORK_INTERFACES.getName());
                    if (networkInterfaces != null) {
                        ArrayList<NetworkInterface> interfaces = new ArrayList<NetworkInterface>();
                        AtomicInteger networkCounter = new AtomicInteger(0);
                        GoogleComputeInstanceMetadata finalInstanceMetadata = instanceMetadata;
                        networkInterfaces.elements().forEachRemaining(jsonNode -> {
                            GoogleComputeNetworkInterface networkInterface = new GoogleComputeNetworkInterface();
                            networkInterface.setId(String.valueOf(networkCounter.getAndIncrement()));
                            if (jsonNode.findValue(GoogleComputeMetadataKeys.ACCESS_CONFIGS.getName()) != null) {
                                JsonNode accessConfigs = jsonNode.findValue(GoogleComputeMetadataKeys.ACCESS_CONFIGS.getName());
                                finalInstanceMetadata.setPublicIpV4(accessConfigs.get(0).findValue("externalIp").textValue());
                            }
                            ComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.IP.getName()).ifPresent(finalInstanceMetadata::setPrivateIpV4);
                            ComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.IP.getName()).ifPresent(networkInterface::setIpv4);
                            ComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.MAC.getName()).ifPresent(networkInterface::setMac);
                            ComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.NETWORK.getName()).ifPresent(networkInterface::setNetwork);
                            ComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.NETMASK.getName()).ifPresent(networkInterface::setNetmask);
                            ComputeInstanceMetadataResolverUtils.stringValue(jsonNode, GoogleComputeMetadataKeys.GATEWAY.getName()).ifPresent(networkInterface::setGateway);
                            interfaces.add(networkInterface);
                        });
                        instanceMetadata.setInterfaces(interfaces);
                    }
                    Map metadata = (Map)this.objectMapper.convertValue((Object)instanceMetadata, Map.class);
                    ComputeInstanceMetadataResolverUtils.populateMetadata(instanceMetadata, metadata);
                    this.cachedMetadata = instanceMetadata;
                    return Optional.of(instanceMetadata);
                }
            }
            catch (MalformedURLException me) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Google compute metadataUrl value is invalid!: " + this.configuration.getMetadataUrl(), (Throwable)me);
                }
            }
            catch (FileNotFoundException fnfe) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No metadata found at: " + this.configuration.getMetadataUrl() + "?recursive=true", (Throwable)fnfe);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isErrorEnabled()) break block23;
                LOG.debug("Error connecting to" + this.configuration.getMetadataUrl() + "?recursive=true reading instance metadata", (Throwable)ioe);
            }
        }
        return Optional.ofNullable(instanceMetadata);
    }

    @Deprecated
    protected JsonNode readGcMetadataUrl(URL url, int connectionTimeoutMs, int readTimeoutMs) throws IOException {
        return ComputeInstanceMetadataResolverUtils.readMetadataUrl(url, connectionTimeoutMs, readTimeoutMs, this.objectMapper, Collections.emptyMap());
    }
}

