/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.discovery.cloud.oraclecloud;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.discovery.cloud.ComputeInstanceMetadata;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolver;
import io.micronaut.discovery.cloud.ComputeInstanceMetadataResolverUtils;
import io.micronaut.discovery.cloud.NetworkInterface;
import io.micronaut.discovery.cloud.oraclecloud.OracleCloudInstanceMetadata;
import io.micronaut.discovery.cloud.oraclecloud.OracleCloudMetadataConfiguration;
import io.micronaut.discovery.cloud.oraclecloud.OracleCloudMetadataKeys;
import io.micronaut.discovery.cloud.oraclecloud.OracleCloudNetworkInterface;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(env={"oraclecloud"})
public class OracleCloudMetadataResolver
implements ComputeInstanceMetadataResolver {
    private static final Logger LOG = LoggerFactory.getLogger(OracleCloudMetadataResolver.class);
    private static final int READ_TIMEOUT_IN_MILLS = 5000;
    private static final int CONNECTION_TIMEOUT_IN_MILLS = 5000;
    private final ObjectMapper objectMapper;
    private final OracleCloudMetadataConfiguration configuration;
    private OracleCloudInstanceMetadata cachedMetadata;

    @Inject
    public OracleCloudMetadataResolver(ObjectMapper objectMapper, OracleCloudMetadataConfiguration configuration) {
        this.objectMapper = objectMapper;
        this.configuration = configuration;
    }

    public OracleCloudMetadataResolver() {
        this.objectMapper = new ObjectMapper();
        this.configuration = new OracleCloudMetadataConfiguration();
    }

    @Override
    public Optional<ComputeInstanceMetadata> resolve(Environment environment) {
        block8: {
            if (!this.configuration.isEnabled()) {
                return Optional.empty();
            }
            if (this.cachedMetadata != null) {
                this.cachedMetadata.setCached(true);
                return Optional.of(this.cachedMetadata);
            }
            OracleCloudInstanceMetadata instanceMetadata = new OracleCloudInstanceMetadata();
            try {
                String vnicUrl;
                JsonNode vnicJson;
                String metadataUrl = this.configuration.getUrl();
                JsonNode metadataJson = ComputeInstanceMetadataResolverUtils.readMetadataUrl(new URL(metadataUrl), 5000, 5000, this.objectMapper, new HashMap<String, String>());
                if (metadataJson != null) {
                    instanceMetadata.setInstanceId(this.textValue(metadataJson, OracleCloudMetadataKeys.ID));
                    instanceMetadata.setName(this.textValue(metadataJson, OracleCloudMetadataKeys.DISPLAY_NAME));
                    instanceMetadata.setRegion(this.textValue(metadataJson, OracleCloudMetadataKeys.CANONICAL_REGION_NAME));
                    instanceMetadata.setAvailabilityZone(this.textValue(metadataJson, OracleCloudMetadataKeys.AVAILABILITY_DOMAIN));
                    instanceMetadata.setImageId(this.textValue(metadataJson, OracleCloudMetadataKeys.IMAGE));
                    instanceMetadata.setMachineType(this.textValue(metadataJson, OracleCloudMetadataKeys.SHAPE));
                    Map metadata = (Map)this.objectMapper.convertValue((Object)metadataJson, Map.class);
                    JsonNode agentConfig = metadataJson.findValue(OracleCloudMetadataKeys.AGENT_CONFIG.getName());
                    metadata.put("timeCreated", this.textValue(metadataJson, OracleCloudMetadataKeys.TIME_CREATED));
                    metadata.put("monitoringDisabled", this.textValue(agentConfig, OracleCloudMetadataKeys.MONITORING_DISABLED));
                    JsonNode userMeta = metadataJson.findValue(OracleCloudMetadataKeys.USER_METADATA.getName());
                    Iterator userMetaFieldNames = userMeta.fieldNames();
                    userMeta.forEach(userNode -> {
                        String fieldName = (String)userMetaFieldNames.next();
                        metadata.put(fieldName, userNode.asText());
                    });
                    metadata.put(OracleCloudMetadataKeys.REGION.getName(), this.textValue(metadataJson, OracleCloudMetadataKeys.CANONICAL_REGION_NAME));
                    metadata.put("zone", this.textValue(metadataJson, OracleCloudMetadataKeys.AVAILABILITY_DOMAIN));
                    ComputeInstanceMetadataResolverUtils.populateMetadata(instanceMetadata, metadata);
                }
                if ((vnicJson = ComputeInstanceMetadataResolverUtils.readMetadataUrl(new URL(vnicUrl = this.configuration.getVnicUrl()), 5000, 5000, this.objectMapper, new HashMap<String, String>())) != null) {
                    ArrayList<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
                    vnicJson.elements().forEachRemaining(vnicNode -> {
                        OracleCloudNetworkInterface networkInterface = new OracleCloudNetworkInterface();
                        networkInterface.setId(this.textValue(vnicJson, OracleCloudMetadataKeys.VNIC_ID));
                        networkInterface.setIpv4(this.textValue(vnicJson, OracleCloudMetadataKeys.PRIVATE_IP));
                        networkInterface.setMac(this.textValue(vnicJson, OracleCloudMetadataKeys.MAC));
                        networkInterfaces.add(networkInterface);
                    });
                    instanceMetadata.setInterfaces(networkInterfaces);
                }
                this.cachedMetadata = instanceMetadata;
                return Optional.of(instanceMetadata);
            }
            catch (MalformedURLException mue) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Oracle Cloud metadataUrl value is invalid!: " + this.configuration.getUrl(), (Throwable)mue);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isErrorEnabled()) break block8;
                LOG.error("Error connecting to" + this.configuration.getUrl() + "reading instance metadata", (Throwable)ioe);
            }
        }
        return Optional.empty();
    }

    private String textValue(JsonNode node, OracleCloudMetadataKeys key) {
        JsonNode value = node.findValue(key.getName());
        if (value != null) {
            return value.asText();
        }
        return null;
    }
}

