/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.http.converters;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.http.HttpStatus;
import java.util.Optional;
import javax.inject.Singleton;

@Requires(classes={HttpStatus.class})
@Singleton
public class HttpStatusConverter
implements TypeConverter<Number, HttpStatus> {
    public Optional<HttpStatus> convert(Number object, Class<HttpStatus> targetType, ConversionContext context) {
        try {
            HttpStatus status = HttpStatus.valueOf((int)object.shortValue());
            return Optional.of(status);
        }
        catch (IllegalArgumentException e) {
            context.reject((Object)object, (Exception)e);
            return Optional.empty();
        }
    }
}

