/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.http.scope;

import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.http.scope.RequestAware;
import io.micronaut.runtime.http.scope.RequestScope;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class RequestCustomScope
implements CustomScope<RequestScope>,
LifeCycle<RequestCustomScope>,
ApplicationEventListener<HttpRequestTerminatedEvent> {
    public static final String SCOPED_BEANS_ATTRIBUTE = "io.micronaut.http.SCOPED_BEANS";
    private static final Logger LOG = LoggerFactory.getLogger(RequestCustomScope.class);
    private final BeanContext beanContext;

    public RequestCustomScope(BeanContext beanContext) {
        this.beanContext = beanContext;
    }

    public Class<RequestScope> annotationType() {
        return RequestScope.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(BeanResolutionContext resolutionContext, BeanDefinition<T> beanDefinition, BeanIdentifier identifier, Provider<T> provider) {
        Optional currentRequest = ServerRequestContext.currentRequest();
        if (!currentRequest.isPresent()) {
            throw new NoSuchBeanException(beanDefinition.getBeanType(), Qualifiers.byStereotype(RequestScope.class));
        }
        HttpRequest httpRequest = (HttpRequest)currentRequest.get();
        Map scopedBeanMap = this.getRequestScopedBeans(httpRequest);
        Object bean = scopedBeanMap.get(identifier);
        if (bean == null) {
            RequestCustomScope requestCustomScope = this;
            synchronized (requestCustomScope) {
                bean = scopedBeanMap.get(identifier);
                if (bean == null) {
                    bean = provider.get();
                    if (bean instanceof RequestAware) {
                        ((RequestAware)bean).setRequest(httpRequest);
                    }
                    scopedBeanMap.put(identifier, bean);
                }
            }
        }
        return (T)bean;
    }

    public <T> Optional<T> remove(BeanIdentifier identifier) {
        return ServerRequestContext.currentRequest().map(this::getRequestScopedBeans).flatMap(m -> this.destroyRequestScopedBean(identifier, (Map)m));
    }

    private <T> Optional<T> destroyRequestScopedBean(BeanIdentifier identifier, Map m) {
        Object bean = m.remove(identifier);
        if (bean != null) {
            this.beanContext.findBeanDefinition(bean.getClass()).ifPresent(definition -> {
                block3: {
                    if (definition instanceof DisposableBeanDefinition) {
                        try {
                            ((DisposableBeanDefinition)definition).dispose(this.beanContext, bean);
                        }
                        catch (Exception e) {
                            if (!LOG.isErrorEnabled()) break block3;
                            LOG.error("Error disposing of request scoped bean: " + bean, (Throwable)e);
                        }
                    }
                }
            });
        }
        return Optional.ofNullable(bean);
    }

    @Nonnull
    public RequestCustomScope stop() {
        ServerRequestContext.currentRequest().ifPresent(this::destroyBeans);
        return this;
    }

    public boolean isRunning() {
        return true;
    }

    public void onApplicationEvent(HttpRequestTerminatedEvent event) {
        this.destroyBeans(event.getSource());
    }

    private void destroyBeans(HttpRequest<?> request) {
        ArgumentUtils.requireNonNull((String)"request", request);
        Map beans = this.getRequestScopedBeans(request);
        if (CollectionUtils.isNotEmpty((Map)beans)) {
            beans.keySet().forEach(o -> {
                if (o instanceof BeanIdentifier) {
                    this.destroyRequestScopedBean((BeanIdentifier)o, beans);
                }
            });
        }
    }

    private synchronized <T> Map getRequestScopedBeans(HttpRequest<T> httpRequest) {
        MutableConvertibleValues attrs = httpRequest.getAttributes();
        return attrs.get((CharSequence)SCOPED_BEANS_ATTRIBUTE, Object.class).flatMap(o -> {
            if (o instanceof Map) {
                return Optional.of((Map)o);
            }
            return Optional.empty();
        }).orElseGet(() -> {
            ConcurrentHashMap scopedBeans = new ConcurrentHashMap(5);
            attrs.put((CharSequence)SCOPED_BEANS_ATTRIBUTE, scopedBeans);
            return scopedBeans;
        });
    }
}

