/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.scheduling.io.watch.event;

import io.micronaut.context.event.ApplicationEvent;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.scheduling.io.watch.event.WatchEventType;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FileChangedEvent
extends ApplicationEvent {
    private final Path path;
    private final WatchEventType eventType;

    public FileChangedEvent(@Nonnull Path path, @Nonnull WatchEventType eventType) {
        super((Object)path);
        ArgumentUtils.requireNonNull((String)"path", (Object)path);
        ArgumentUtils.requireNonNull((String)"eventType", (Object)((Object)eventType));
        this.path = path;
        this.eventType = eventType;
    }

    public FileChangedEvent(@Nonnull Path path, @Nonnull WatchEvent.Kind eventType) {
        this(path, WatchEventType.of(eventType));
    }

    @Nonnull
    public Path getSource() {
        return (Path)super.getSource();
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    @Nonnull
    public WatchEventType getEventType() {
        return this.eventType;
    }
}

