/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.exceptions;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.hateoas.Link;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import java.net.URI;
import javax.inject.Singleton;
import org.grails.datastore.mapping.validation.ValidationException;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;

@Singleton
@Requires(classes={ValidationException.class})
public class ValidationExceptionHandler
implements ExceptionHandler<ValidationException, HttpResponse<JsonError>> {
    public HttpResponse<JsonError> handle(HttpRequest request, ValidationException exception) {
        Errors errors = exception.getErrors();
        JsonError error = new JsonError(exception.getMessage());
        FieldError fieldError = errors.getFieldError();
        if (fieldError != null) {
            error.path(fieldError.getField());
        }
        error.link(Link.SELF, Link.of((URI)request.getUri()));
        return HttpResponse.badRequest((Object)error);
    }
}

