/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.views.rocker;

import com.fizzed.rocker.BindableRockerModel;
import com.fizzed.rocker.RockerModel;
import io.micronaut.core.io.Writable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.annotation.Produces;
import io.micronaut.views.ViewsConfiguration;
import io.micronaut.views.ViewsRenderer;
import io.micronaut.views.rocker.RockerEngine;
import io.micronaut.views.rocker.RockerViewsRendererConfiguration;
import io.micronaut.views.rocker.RockerWritable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Produces(value={"text/html"})
@Singleton
public class RockerViewsRenderer
implements ViewsRenderer {
    protected final RockerEngine rockerEngine;
    protected final ViewsConfiguration viewsConfiguration;
    protected final RockerViewsRendererConfiguration rockerConfiguration;
    protected final String folder;

    @Inject
    RockerViewsRenderer(ViewsConfiguration viewsConfiguration, RockerViewsRendererConfiguration rockerConfiguration, RockerEngine rockerEngine) {
        this.viewsConfiguration = viewsConfiguration;
        this.rockerConfiguration = rockerConfiguration;
        this.rockerEngine = rockerEngine;
        this.folder = viewsConfiguration.getFolder();
    }

    @Nonnull
    public Writable render(@Nonnull String view, @Nullable Object data) {
        ArgumentUtils.requireNonNull((String)"view", (Object)view);
        Map context = this.modelOf(data);
        BindableRockerModel model = this.rockerConfiguration.isRelaxed() ? this.rockerEngine.template(view).relaxedBind(context) : this.rockerEngine.template(view).bind(context);
        return new RockerWritable((RockerModel)model);
    }

    public boolean exists(@Nonnull String viewName) {
        return this.rockerEngine.exists(viewName);
    }
}

