/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.reactor.instrument;

import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.propagation.PropagatedContext;
import io.micronaut.reactor.config.ReactorConfiguration;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Optional;
import reactor.core.scheduler.Schedulers;

@Requires(classes={Schedulers.Factory.class, PropagatedContext.class})
@Context
@Internal
final class ReactorInstrumentation {
    static final String KEY = "MICRONAUT_CONTEXT_PROPAGATION";
    private final boolean enableScheduleHookContextPropagation;

    ReactorInstrumentation(ReactorConfiguration configuration) {
        this.enableScheduleHookContextPropagation = Optional.ofNullable(configuration.enableScheduleHookContextPropagation()).orElse(true);
    }

    @PostConstruct
    void init() {
        if (this.enableScheduleHookContextPropagation) {
            Schedulers.onScheduleHook((String)KEY, PropagatedContext::wrapCurrent);
        }
    }

    @PreDestroy
    void removeInstrumentation() {
        if (this.enableScheduleHookContextPropagation) {
            Schedulers.resetOnScheduleHook((String)KEY);
        }
    }
}

