/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cookie.CookieConfiguration;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

public abstract class AbstractCookieConfiguration
implements CookieConfiguration {
    private static final boolean DEFAULT_HTTPONLY = true;
    private static final String DEFAULT_COOKIEPATH = "/";
    private static final Duration DEFAULT_MAX_AGE = Duration.ofMinutes(5L);
    protected String cookieDomain;
    protected Boolean cookieSecure;
    protected String cookiePath = "/";
    protected Boolean cookieHttpOnly = true;
    protected Duration cookieMaxAge = DEFAULT_MAX_AGE;
    protected String cookieName = null;
    protected boolean sessionCookie;

    public boolean isSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(boolean sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public Optional<String> getCookieDomain() {
        return Optional.ofNullable(this.cookieDomain);
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public Optional<Boolean> isCookieSecure() {
        return Optional.ofNullable(this.cookieSecure);
    }

    public void setCookieSecure(Boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    @NonNull
    public String getCookieName() {
        if (this.cookieName != null) {
            return this.cookieName;
        }
        return this.defaultCookieName();
    }

    public void setCookieName(@NonNull String cookieName) {
        this.cookieName = cookieName;
    }

    public abstract String defaultCookieName();

    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public Optional<Boolean> isCookieHttpOnly() {
        return Optional.ofNullable(this.cookieHttpOnly);
    }

    public void setCookieHttpOnly(Boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public Optional<TemporalAmount> getCookieMaxAge() {
        if (this.isSessionCookie()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.cookieMaxAge);
    }

    public void setCookieMaxAge(Duration cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }
}

