/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.configuration.endpoints.SecureEndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultSecureEndpoint
implements SecureEndpoint {
    @NonNull
    private final String url;
    @Nullable
    private final Set<String> supportedAuthenticationMethods;

    public DefaultSecureEndpoint(@NonNull SecureEndpointConfiguration secureEndpointConfiguration, @NonNull String defaultAuthMethod) {
        this(secureEndpointConfiguration.getUrl().orElseThrow(() -> new IllegalArgumentException("URL is required")), Collections.singleton(secureEndpointConfiguration.getAuthenticationMethod().orElse(defaultAuthMethod)));
    }

    public DefaultSecureEndpoint(@NonNull String url, @Nullable Set<String> supportedAuthenticationMethods) {
        this.url = url;
        this.supportedAuthenticationMethods = supportedAuthenticationMethods;
    }

    @Deprecated
    public DefaultSecureEndpoint(@NonNull String url, @Nullable List<AuthenticationMethod> supportedAuthenticationMethods) {
        this.url = url;
        this.supportedAuthenticationMethods = supportedAuthenticationMethods == null ? null : supportedAuthenticationMethods.stream().map(AuthenticationMethod::toString).collect(Collectors.toSet());
    }

    @Override
    @NonNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public Set<String> getAuthenticationMethodsSupported() {
        return this.supportedAuthenticationMethods;
    }

    @Override
    @Deprecated(forRemoval=true)
    public Optional<List<AuthenticationMethod>> getSupportedAuthenticationMethods() {
        if (this.supportedAuthenticationMethods == null) {
            return Optional.empty();
        }
        ArrayList<AuthenticationMethod> result = new ArrayList<AuthenticationMethod>();
        for (String authMethod : this.supportedAuthenticationMethods) {
            try {
                result.add(AuthenticationMethod.valueOf(authMethod.toUpperCase()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return Optional.of(result);
    }
}

