/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.client.clientcredentials.AbstractClientCredentialsClient;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.AuthenticationMethod;
import io.micronaut.security.oauth2.endpoint.DefaultSecureEndpoint;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.ClientCredentialsTokenRequestContext;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class DefaultClientCredentialsOpenIdClient
extends AbstractClientCredentialsClient {
    private final Supplier<OpenIdProviderMetadata> openIdProviderMetadata;
    private final Supplier<SecureEndpoint> tokenEndpoint;

    public DefaultClientCredentialsOpenIdClient(@NonNull OauthClientConfiguration oauthClientConfiguration, @NonNull TokenEndpointClient tokenEndpointClient, Supplier<OpenIdProviderMetadata> openIdProviderMetadata) {
        super(oauthClientConfiguration, tokenEndpointClient);
        this.openIdProviderMetadata = openIdProviderMetadata;
        this.tokenEndpoint = SupplierUtil.memoized(this::getTokenEndpoint);
    }

    @Override
    protected ClientCredentialsTokenRequestContext createTokenRequestContext(String scope) {
        return new ClientCredentialsTokenRequestContext(scope, this.tokenEndpoint.get(), this.oauthClientConfiguration);
    }

    protected SecureEndpoint getTokenEndpoint() {
        Optional<List<AuthenticationMethod>> authMethodsSupported = this.openIdProviderMetadata.get().getTokenEndpointAuthMethods();
        return new DefaultSecureEndpoint(this.openIdProviderMetadata.get().getTokenEndpoint(), authMethodsSupported.orElse(null));
    }
}

