/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.pkce.persistence.session;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.Pkce;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.persistence.PkcePersistence;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.session.http.SessionForRequest;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requires(beans={SessionStore.class})
@Singleton
public class SessionPkcePersistence
implements PkcePersistence {
    private static final String SESSION_KEY = "oauth2pkce";
    private final SessionStore<Session> sessionStore;

    public SessionPkcePersistence(SessionStore<Session> sessionStore) {
        this.sessionStore = sessionStore;
    }

    @Override
    @NonNull
    public Optional<String> retrieveCodeVerifier(@NonNull HttpRequest<?> request) {
        return SessionForRequest.find(request).flatMap(session -> {
            Optional state = session.get((CharSequence)SESSION_KEY, String.class);
            if (state.isPresent()) {
                session.remove((CharSequence)SESSION_KEY);
            }
            return state;
        });
    }

    @Override
    public void persistPkce(@NonNull HttpRequest<?> request, @NonNull MutableHttpResponse<?> response, @NonNull Pkce pkce) {
        Session session = SessionForRequest.find(request).orElseGet(() -> SessionForRequest.create(this.sessionStore, (HttpRequest)request));
        session.put((CharSequence)SESSION_KEY, (Object)pkce.getCodeVerifier());
    }
}

