/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.state.persistence.session;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.authorization.state.persistence.StatePersistence;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.session.http.SessionForRequest;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requires(beans={SessionStore.class})
@Singleton
public class SessionStatePersistence
implements StatePersistence {
    private static final String SESSION_KEY = "oauth2State";
    private final SessionStore<Session> sessionStore;

    public SessionStatePersistence(SessionStore<Session> sessionStore) {
        this.sessionStore = sessionStore;
    }

    @Override
    public Optional<State> retrieveState(HttpRequest<?> request) {
        return SessionForRequest.find(request).flatMap(session -> {
            Optional state = session.get((CharSequence)SESSION_KEY, State.class);
            if (state.isPresent()) {
                session.remove((CharSequence)SESSION_KEY);
            }
            return state;
        });
    }

    @Override
    public void persistState(HttpRequest<?> request, MutableHttpResponse response, State state) {
        Session session = SessionForRequest.find(request).orElseGet(() -> SessionForRequest.create(this.sessionStore, (HttpRequest)request));
        session.put((CharSequence)SESSION_KEY, (Object)state);
    }
}

