/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.core.annotation.NonNull;
import java.util.Optional;

public enum AuthorizationServer {
    OKTA,
    COGNITO,
    KEYCLOAK,
    AUTH0;

    private static final String ISSUER_PART_OKTA = "okta";
    private static final String ISSUER_PART_COGNITO = "cognito";
    private static final String ISSUER_PART_AUTH0 = "auth0";
    private static final String ISSUER_PART_KEYCLOAK = "/auth/realms/";

    @NonNull
    public static Optional<AuthorizationServer> infer(@NonNull String issuer) {
        if (issuer.contains(ISSUER_PART_OKTA)) {
            return Optional.of(OKTA);
        }
        if (issuer.contains(ISSUER_PART_COGNITO)) {
            return Optional.of(COGNITO);
        }
        if (issuer.contains(ISSUER_PART_AUTH0)) {
            return Optional.of(AUTH0);
        }
        if (issuer.contains(ISSUER_PART_KEYCLOAK)) {
            return Optional.of(KEYCLOAK);
        }
        return Optional.empty();
    }
}

