/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.grants;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.grants.AbstractClientSecureGrant;
import io.micronaut.security.oauth2.grants.AsMap;
import io.micronaut.security.oauth2.grants.GrantType;
import io.micronaut.security.oauth2.grants.SecureGrant;
import java.util.Map;

@Introspected
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AuthorizationCodeGrant
extends AbstractClientSecureGrant
implements SecureGrant,
AsMap {
    private static final String KEY_REDIRECT_URI = "redirect_uri";
    private static final String KEY_CODE = "code";
    private static final String KEY_CODE_VERIFIER = "code_verifier";
    private String grantType = GrantType.AUTHORIZATION_CODE.toString();
    private String redirectUri;
    private String code;
    @Nullable
    private String codeVerifier;

    @Override
    @NonNull
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    public void setGrantType(@NonNull String grantType) {
        this.grantType = grantType;
    }

    @NonNull
    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(@NonNull String redirectUri) {
        this.redirectUri = redirectUri;
    }

    @NonNull
    public String getCode() {
        return this.code;
    }

    public void setCode(@NonNull String code) {
        this.code = code;
    }

    @Nullable
    public String getCodeVerifier() {
        return this.codeVerifier;
    }

    public void setCodeVerifier(@Nullable String codeVerifier) {
        this.codeVerifier = codeVerifier;
    }

    @Override
    @NonNull
    public Map<String, String> toMap() {
        Map<String, String> m = super.toMap();
        m.put(KEY_CODE, this.getCode());
        if (this.redirectUri != null) {
            m.put(KEY_REDIRECT_URI, this.getRedirectUri());
        }
        if (this.codeVerifier != null) {
            m.put(KEY_CODE_VERIFIER, this.codeVerifier);
        }
        return m;
    }
}

