/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import io.micronaut.serde.support.DeserializerRegistrar;
import java.io.IOException;
import java.util.EnumSet;

@Internal
final class EnumSetDeserializer<E extends Enum<E>>
implements DeserializerRegistrar<EnumSet<E>> {
    EnumSetDeserializer() {
    }

    public EnumSet<E> deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super EnumSet<E>> type) throws IOException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics)) {
            throw new SerdeException("Cannot deserialize raw EnumSet");
        }
        Object generic = generics[0];
        Decoder arrayDecoder = decoder.decodeArray();
        Class enumType = generic.getType();
        EnumSet<Enum> enumSet = EnumSet.noneOf(enumType);
        Deserializer enumDeser = context.findDeserializer(enumType).createSpecific(context, (Argument)generic);
        int index = 0;
        while (arrayDecoder.hasNextArrayValue()) {
            try {
                enumSet.add((Enum)enumDeser.deserialize(arrayDecoder, context, (Argument)generic));
                ++index;
            }
            catch (SerdeException e) {
                e.getPath().add(ReferencePath.ofCollection(enumSet.getClass(), type, (int)index));
                throw e;
            }
        }
        arrayDecoder.finishStructure();
        return enumSet;
    }

    @Override
    public Argument<EnumSet<E>> getType() {
        return Argument.of(EnumSet.class, (Argument[])new Argument[]{Argument.ofTypeVariable(Enum.class, (String)"E")});
    }
}

