/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serializers;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.ObjectSerializer;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.exceptions.path.ReferencePath;
import io.micronaut.serde.support.util.SerdeArgumentConf;
import java.io.IOException;
import java.util.Map;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Internal
abstract class AbstractMapObjectSerializer<K, V>
implements ObjectSerializer<Map<K, V>> {
    protected final SerdeConfig.SerInclude includeContent;
    private final Argument<V> valueGeneric;
    private final Serializer<V> valueSerializer;

    AbstractMapObjectSerializer(Argument<? extends Map<K, V>> type, Serializer.EncoderContext context) throws SerdeException {
        this.includeContent = type.getAnnotationMetadata().enumValue(SerdeConfig.class.getName(), "includeContent", SerdeConfig.SerInclude.class).orElse(SerdeConfig.SerInclude.ALWAYS);
        Object[] generics = type.getTypeParameters();
        boolean hasGenerics = ArrayUtils.isNotEmpty((Object[])generics) && generics.length == 2;
        this.valueGeneric = hasGenerics ? SerdeArgumentConf.reconstructGenericWithParentMetadata(type, generics[1]) : SerdeArgumentConf.reconstructGenericWithParentMetadata(type, Argument.OBJECT_ARGUMENT);
        this.valueSerializer = context.findSerializer(this.valueGeneric).createSpecific(context, this.valueGeneric);
    }

    protected abstract void encodeKey(Encoder var1, Serializer.EncoderContext var2, K var3) throws IOException;

    public final void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
        Encoder objectEncoder = encoder.encodeObject(type);
        this.serializeInto(objectEncoder, context, type, value);
        objectEncoder.finishStructure();
    }

    public void serializeInto(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Map<K, V>> type, Map<K, V> value) throws IOException {
        block7: for (Map.Entry<K, V> entry : value.entrySet()) {
            K k = entry.getKey();
            try {
                V v = entry.getValue();
                switch (this.includeContent) {
                    case NON_ABSENT: {
                        if (!this.valueSerializer.isAbsent(context, v)) break;
                        continue block7;
                    }
                    case NON_EMPTY: {
                        if (!this.valueSerializer.isEmpty(context, v)) break;
                        continue block7;
                    }
                    case NON_NULL: {
                        if (v != null) break;
                        continue block7;
                    }
                }
                if (k == null) {
                    encoder.encodeNull();
                } else {
                    this.encodeKey(encoder, context, k);
                }
                if (v == null) {
                    encoder.encodeNull();
                    continue;
                }
                this.valueSerializer.serialize(encoder, context, this.valueGeneric, v);
            }
            catch (SerdeException e) {
                e.getPath().add(ReferencePath.ofMap(value.getClass(), type, (String)(k == null ? "<null>" : k.toString())));
                throw e;
            }
        }
    }

    public final boolean isAbsent(Serializer.EncoderContext context, Map<K, V> value) {
        return value == null;
    }

    public final boolean isEmpty(Serializer.EncoderContext context, Map<K, V> value) {
        if (CollectionUtils.isEmpty(value)) {
            return true;
        }
        if (this.includeContent != SerdeConfig.SerInclude.ALWAYS) {
            block5: for (V v : value.values()) {
                switch (this.includeContent) {
                    case NON_ABSENT: {
                        if (this.valueSerializer.isAbsent(context, v)) continue block5;
                        return false;
                    }
                    case NON_EMPTY: {
                        if (this.valueSerializer.isEmpty(context, v)) continue block5;
                        return false;
                    }
                    case NON_NULL: {
                        if (v == null) continue block5;
                        return false;
                    }
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

