/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.support.SerdeRegistrar;
import java.io.IOException;
import java.time.ZoneId;

@Internal
final class ZoneIdSerde
implements SerdeRegistrar<ZoneId> {
    ZoneIdSerde() {
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends ZoneId> type, ZoneId value) throws IOException {
        encoder.encodeString(value.getId());
    }

    public ZoneId deserialize(Decoder decoder, Deserializer.DecoderContext context, Argument<? super ZoneId> type) throws IOException {
        return ZoneId.of(decoder.decodeString());
    }

    public ZoneId deserializeNullable(Decoder decoder, Deserializer.DecoderContext context, Argument<? super ZoneId> type) throws IOException {
        if (decoder.decodeNull()) {
            return null;
        }
        return this.deserialize(decoder, context, (Argument)type);
    }

    @Override
    public Argument<ZoneId> getType() {
        return Argument.of(ZoneId.class);
    }
}

