/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.util;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.config.annotation.SerdeConfig;
import java.util.Optional;
import org.jetbrains.annotations.Contract;

@Internal
public final class JsonViewUtil {
    private JsonViewUtil() {
    }

    @Contract(pure=true, value="_, _, !null -> !null")
    public static Class<?> extractView(@Nullable SerdeConfiguration configuration, @NonNull Argument<?> argument, Class<?> defaultValue) {
        if (configuration != null && configuration.isJsonViewEnabled()) {
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            Optional jackson = annotationMetadata.classValue("com.fasterxml.jackson.annotation.JsonView");
            if (jackson.isPresent()) {
                return (Class)jackson.get();
            }
            Optional serde = annotationMetadata.classValue(SerdeConfig.class, "views");
            if (serde.isPresent()) {
                return (Class)serde.get();
            }
        }
        return defaultValue;
    }
}

