/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.DefaultRequestBinderRegistry;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.bind.binders.RequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.servlet.http.ServletBodyBinder;
import io.micronaut.servlet.http.ServletRequestBinder;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ServletBinderRegistry
implements RequestBinderRegistry {
    private static final String BINDABLE_ANN = Bindable.class.getName();
    protected final Map<Class<? extends Annotation>, RequestArgumentBinder> byAnnotation = new LinkedHashMap<Class<? extends Annotation>, RequestArgumentBinder>(5);
    protected final Map<Class<?>, RequestArgumentBinder> byType = new LinkedHashMap(5);
    private final DefaultRequestBinderRegistry defaultRegistry;

    public ServletBinderRegistry(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService, List<RequestArgumentBinder> binders) {
        this.defaultRegistry = new DefaultRequestBinderRegistry(conversionService, binders);
        this.byAnnotation.put(Body.class, (RequestArgumentBinder)this.newServletBodyBinder(mediaTypeCodecRegistry, conversionService));
        this.byType.put(HttpRequest.class, (RequestArgumentBinder)new ServletRequestBinder(mediaTypeCodecRegistry));
    }

    protected ServletBodyBinder newServletBodyBinder(MediaTypeCodecRegistry mediaTypeCodecRegistry, ConversionService conversionService) {
        return new ServletBodyBinder(conversionService, mediaTypeCodecRegistry);
    }

    public <T> Optional<ArgumentBinder<T, HttpRequest<?>>> findArgumentBinder(Argument<T> argument, HttpRequest<?> source) {
        RequestArgumentBinder binder;
        Class annotation = argument.getAnnotationMetadata().getAnnotationTypeByStereotype(BINDABLE_ANN).orElse(null);
        if (annotation != null && (binder = this.byAnnotation.get(annotation)) != null) {
            return Optional.of(binder);
        }
        RequestArgumentBinder requestArgumentBinder = this.byType.get(argument.getType());
        if (requestArgumentBinder != null) {
            return Optional.of(requestArgumentBinder);
        }
        return this.defaultRegistry.findArgumentBinder(argument, source);
    }
}

