/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.io.IOUtils;
import io.micronaut.core.io.Readable;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.bind.binders.AnnotatedRequestArgumentBinder;
import io.micronaut.http.bind.binders.DefaultBodyAnnotationBinder;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.reactivex.Flowable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;

public class ServletBodyBinder<T>
extends DefaultBodyAnnotationBinder<T>
implements AnnotatedRequestArgumentBinder<Body, T> {
    private final MediaTypeCodecRegistry mediaTypeCodeRegistry;

    protected ServletBodyBinder(ConversionService<?> conversionService, MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        super(conversionService);
        this.mediaTypeCodeRegistry = mediaTypeCodecRegistry;
    }

    public Class<Body> getAnnotationType() {
        return Body.class;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArgumentBinder.BindingResult<T> bind(ArgumentConversionContext<T> context, HttpRequest<?> source) {
        Argument argument = context.getArgument();
        Class type = argument.getType();
        String name = argument.getAnnotationMetadata().stringValue(Body.class).orElse(null);
        if (!(source instanceof ServletHttpRequest)) return super.bind(context, source);
        final ServletHttpRequest servletHttpRequest = (ServletHttpRequest)source;
        if (Readable.class.isAssignableFrom(type)) {
            Readable readable = new Readable(){

                public Reader asReader() throws IOException {
                    return servletHttpRequest.getReader();
                }

                @Nonnull
                public InputStream asInputStream() throws IOException {
                    return servletHttpRequest.getInputStream();
                }

                public boolean exists() {
                    return true;
                }

                @Nonnull
                public String getName() {
                    return servletHttpRequest.getPath();
                }
            };
            return () -> Optional.of(readable);
        }
        if (CharSequence.class.isAssignableFrom(type) && name == null) {
            try (InputStream inputStream = servletHttpRequest.getInputStream();){
                String content = IOUtils.readText((BufferedReader)new BufferedReader(new InputStreamReader(inputStream, source.getCharacterEncoding())));
                ArgumentBinder.BindingResult bindingResult = () -> Optional.of(content);
                return bindingResult;
            }
            catch (IOException e) {
                return new ArgumentBinder.BindingResult<T>(){

                    public Optional<T> getValue() {
                        return Optional.empty();
                    }

                    public List<ConversionError> getConversionErrors() {
                        return Collections.singletonList(() -> e);
                    }
                };
            }
        }
        MediaType mediaType = source.getContentType().orElse(MediaType.APPLICATION_JSON_TYPE);
        if (this.isFormSubmission(mediaType)) {
            if (name != null) {
                return () -> servletHttpRequest.getParameters().get((CharSequence)name, context);
            }
            Optional result = this.conversionService.convert((Object)servletHttpRequest.getParameters().asMap(), context);
            return () -> result;
        }
        MediaTypeCodec codec = this.mediaTypeCodeRegistry.findCodec(mediaType, type).orElse(null);
        if (codec == null) return super.bind(context, source);
        try (InputStream inputStream = servletHttpRequest.getInputStream();){
            if (Publishers.isConvertibleToPublisher((Class)type)) {
                Argument typeArg = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                if (Publishers.isSingle((Class)type)) {
                    Object content = codec.decode(typeArg, inputStream);
                    Publisher publisher = Publishers.just((Object)content);
                    Object converted = this.conversionService.convertRequired((Object)publisher, type);
                    ArgumentBinder.BindingResult bindingResult = () -> Optional.of(converted);
                    return bindingResult;
                }
                Argument containerType = Argument.listOf((Class)typeArg.getType());
                Object content = codec.decode(containerType, inputStream);
                Flowable flowable = Flowable.fromIterable((Iterable)((Iterable)content));
                Object converted = this.conversionService.convertRequired((Object)flowable, type);
                ArgumentBinder.BindingResult bindingResult = () -> Optional.of(converted);
                return bindingResult;
            }
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                List content = (List)codec.decode(Argument.listOf(componentType), inputStream);
                Object[] array = content.toArray((Object[])Array.newInstance(componentType, 0));
                ArgumentBinder.BindingResult bindingResult = () -> Optional.of(array);
                return bindingResult;
            }
            Object content = codec.decode(argument, inputStream);
            ArgumentBinder.BindingResult bindingResult = () -> Optional.of(content);
            return bindingResult;
        }
        catch (CodecException | IOException e) {
            throw new CodecException("Unable to decode request body: " + e.getMessage(), e);
        }
    }

    private boolean isFormSubmission(MediaType contentType) {
        return MediaType.APPLICATION_FORM_URLENCODED_TYPE.equals((Object)contentType) || MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)contentType);
    }
}

