/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.LifeCycle;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.exceptions.ConversionErrorException;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.io.Writable;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.ReturnType;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpHeaders;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Header;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Status;
import io.micronaut.http.codec.CodecException;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.http.filter.FilterChain;
import io.micronaut.http.filter.HttpFilter;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.http.hateoas.JsonError;
import io.micronaut.http.server.binding.RequestArgumentSatisfier;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.micronaut.servlet.http.ServletResponseEncoder;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.DuplicateRouteException;
import io.micronaut.web.router.exceptions.UnsatisfiedRouteException;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServletHttpHandler<Req, Res>
implements AutoCloseable,
LifeCycle<ServletHttpHandler<Req, Res>> {
    protected static final Logger LOG = LoggerFactory.getLogger(ServletHttpHandler.class);
    private final Router router;
    private final RequestArgumentSatisfier requestArgumentSatisfier;
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;
    private final ApplicationContext applicationContext;
    private final Map<Class<?>, ServletResponseEncoder<?>> responseEncoders;

    public ServletHttpHandler(ApplicationContext applicationContext) {
        this.applicationContext = Objects.requireNonNull(applicationContext, "The application context cannot be null");
        this.router = (Router)applicationContext.getBean(Router.class);
        this.requestArgumentSatisfier = (RequestArgumentSatisfier)applicationContext.getBean(RequestArgumentSatisfier.class);
        this.mediaTypeCodecRegistry = (MediaTypeCodecRegistry)applicationContext.getBean(MediaTypeCodecRegistry.class);
        this.responseEncoders = applicationContext.streamOfType(ServletResponseEncoder.class).collect(Collectors.toMap(ServletResponseEncoder::getResponseType, o -> o));
        applicationContext.getEnvironment().addConverter(HttpRequest.class, HttpRequest.class, httpRequest -> httpRequest);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public MediaTypeCodecRegistry getMediaTypeCodecRegistry() {
        return this.mediaTypeCodecRegistry;
    }

    public void service(Req request, Res response) {
        ServletExchange<Req, Res> exchange = this.createExchange(request, response);
        this.service(exchange);
    }

    public ServletExchange<Req, Res> exchange(Req request, Res response) {
        ServletExchange<Req, Res> servletExchange = this.createExchange(request, response);
        return this.exchange(servletExchange);
    }

    public ServletExchange<Req, Res> exchange(ServletExchange<Req, Res> exchange) {
        this.service(Objects.requireNonNull(exchange, "The exchange cannot be null"));
        return exchange;
    }

    public boolean isRunning() {
        return this.getApplicationContext().isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletExchange<Req, Res> exchange) {
        long time;
        block17: {
            time = System.currentTimeMillis();
            try {
                Set existingRouteMethods;
                ServletHttpResponse res = exchange.getResponse();
                ServletHttpRequest req = exchange.getRequest();
                List matchingRoutes = this.router.findAllClosest(req);
                if (CollectionUtils.isNotEmpty((Collection)matchingRoutes)) {
                    if (matchingRoutes.size() > 1) {
                        throw new DuplicateRouteException(req.getPath(), matchingRoutes);
                    }
                    UriRouteMatch establishedRoute = (UriRouteMatch)matchingRoutes.get(0);
                    req.setAttribute((CharSequence)HttpAttributes.ROUTE, establishedRoute.getRoute());
                    req.setAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, establishedRoute);
                    req.setAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, establishedRoute.getRoute().getUriMatchTemplate().toString());
                    UriRouteMatch route = establishedRoute;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} - {} - routed to controller {}", new Object[]{req.getMethodName(), req.getPath(), route.getDeclaringType().getSimpleName()});
                        this.traceHeaders(req.getHeaders());
                    }
                    this.invokeRouteMatch((HttpRequest<Object>)req, (MutableHttpResponse<Object>)res, (RouteMatch<?>)route, false, exchange);
                    break block17;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} - {} - No matching routes found", (Object)req.getMethodName(), (Object)req.getPath());
                    this.traceHeaders(req.getHeaders());
                }
                if (CollectionUtils.isNotEmpty(existingRouteMethods = this.router.findAny((CharSequence)req.getUri().toString(), req).map(UriRouteMatch::getRoute).map(UriRoute::getHttpMethodName).collect(Collectors.toSet()))) {
                    if (existingRouteMethods.contains(req.getMethodName())) {
                        MediaType contentType = req.getContentType().orElse(null);
                        if (contentType != null) {
                            boolean invalidMediaType = this.router.findAny((CharSequence)req.getUri().toString(), req).anyMatch(rm -> rm.accept(contentType));
                            if (!invalidMediaType) {
                                this.handleStatusRoute(exchange, res, req, HttpStatus.UNSUPPORTED_MEDIA_TYPE);
                            } else {
                                this.handlePageNotFound(exchange, res, req);
                            }
                        } else {
                            this.handlePageNotFound(exchange, res, req);
                        }
                    } else {
                        RouteMatch notAllowedRoute = this.router.route(HttpStatus.METHOD_NOT_ALLOWED).orElse(null);
                        if (notAllowedRoute != null) {
                            this.invokeRouteMatch(req, res, notAllowedRoute, true, exchange);
                        } else {
                            this.emitError(exchange, res, req, emitter -> {
                                res.getHeaders().allowGeneric((Collection)existingRouteMethods);
                                res.status(HttpStatus.METHOD_NOT_ALLOWED).body((Object)new JsonError("Method [" + req.getMethod() + "] not allowed for URI [" + req.getPath() + "]. Allowed methods: " + existingRouteMethods));
                                emitter.onNext((Object)res);
                                emitter.onComplete();
                            });
                        }
                    }
                    break block17;
                }
                this.handlePageNotFound(exchange, res, req);
            }
            catch (Throwable throwable) {
                if (LOG.isTraceEnabled()) {
                    ServletHttpRequest<Req, Object> r = exchange.getRequest();
                    LOG.trace("Executed HTTP Request [{} {}] in: {}ms", new Object[]{r.getMethod(), r.getPath(), System.currentTimeMillis() - time});
                }
                throw throwable;
            }
        }
        if (LOG.isTraceEnabled()) {
            ServletHttpRequest<Req, Object> r = exchange.getRequest();
            LOG.trace("Executed HTTP Request [{} {}] in: {}ms", new Object[]{r.getMethod(), r.getPath(), System.currentTimeMillis() - time});
        }
    }

    private void emitError(ServletExchange<Req, Res> exchange, MutableHttpResponse<Object> res, HttpRequest<Object> req, FlowableOnSubscribe<MutableHttpResponse<?>> errorEmitter) {
        Publisher<MutableHttpResponse<?>> responsePublisher = Flowable.create(errorEmitter, (BackpressureStrategy)BackpressureStrategy.LATEST);
        responsePublisher = this.filterPublisher(new AtomicReference(req), responsePublisher, false);
        this.subscribeToResponsePublisher(req, res, null, true, exchange, responsePublisher, AnnotationMetadata.EMPTY_METADATA);
    }

    private void traceHeaders(HttpHeaders httpHeaders) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("-----");
            httpHeaders.forEach((name, values) -> LOG.trace("{} : {}", name, values));
            LOG.trace("-----");
        }
    }

    private void handlePageNotFound(ServletExchange<Req, Res> exchange, MutableHttpResponse<Object> res, HttpRequest<Object> req) {
        this.handleStatusRoute(exchange, res, req, HttpStatus.NOT_FOUND);
    }

    private void handleStatusRoute(ServletExchange<Req, Res> exchange, MutableHttpResponse<Object> res, HttpRequest<Object> req, HttpStatus httpStatus) {
        RouteMatch notFoundRoute = this.router.route(httpStatus).orElse(null);
        if (notFoundRoute != null) {
            this.invokeRouteMatch(req, res, notFoundRoute, true, exchange);
        } else {
            this.emitError(exchange, res, req, emitter -> {
                res.status(httpStatus).body((Object)this.newJsonError(req, httpStatus.getReason()));
                emitter.onNext((Object)res);
                emitter.onComplete();
            });
        }
    }

    @Override
    public void close() {
        if (this.applicationContext.isRunning()) {
            this.applicationContext.close();
        }
    }

    @Nonnull
    public ServletHttpHandler<Req, Res> start() {
        if (!this.applicationContext.isRunning()) {
            this.applicationContext.start();
        }
        return this;
    }

    @Nonnull
    public ServletHttpHandler<Req, Res> stop() {
        this.close();
        return this;
    }

    protected abstract ServletExchange<Req, Res> createExchange(Req var1, Res var2);

    private void invokeRouteMatch(HttpRequest<Object> req, MutableHttpResponse<Object> res, RouteMatch<?> route, boolean isErrorRoute, ServletExchange<Req, Res> exchange) {
        try {
            Publisher<MutableHttpResponse<?>> responsePublisher = this.buildResponsePublisher(req, res, route, isErrorRoute);
            AnnotationMetadata annotationMetadata = route.getAnnotationMetadata();
            this.subscribeToResponsePublisher(req, res, route, isErrorRoute, exchange, responsePublisher, annotationMetadata);
        }
        catch (Throwable e) {
            this.handleException(req, res, route, isErrorRoute, e, exchange);
        }
    }

    private void subscribeToResponsePublisher(HttpRequest<Object> req, MutableHttpResponse<Object> res, RouteMatch<?> route, boolean isErrorRoute, ServletExchange<Req, Res> exchange, Publisher<? extends MutableHttpResponse<?>> responsePublisher, AnnotationMetadata annotationMetadata) {
        ServletHttpRequest<Req, Object> exchangeRequest = exchange.getRequest();
        boolean isAsyncSupported = exchangeRequest.isAsyncSupported();
        Flowable responseFlowable = Flowable.fromPublisher(responsePublisher).flatMap(response -> {
            Class<?> bodyType;
            ServletResponseEncoder<?> responseEncoder;
            RouteMatch<Object> errorRoute;
            HttpStatus status = response.status();
            Object body = response.body();
            if (body != null) {
                if (Publishers.isConvertibleToPublisher((Object)body)) {
                    boolean isSingle = Publishers.isSingle(body.getClass());
                    if (isSingle) {
                        Flowable flowable = (Flowable)Publishers.convertPublisher((Object)body, Flowable.class);
                        return flowable.map(o -> {
                            if (o instanceof HttpResponse) {
                                this.encodeResponse(exchange, annotationMetadata, (HttpResponse)o);
                                return res;
                            }
                            ServletHttpResponse res1 = exchange.getResponse();
                            res1.body(o);
                            this.encodeResponse(exchange, annotationMetadata, (HttpResponse<?>)response);
                            return res1;
                        }).switchIfEmpty((Publisher)Flowable.defer(() -> {
                            RouteMatch<Object> errorRoute = this.lookupStatusRoute(route, HttpStatus.NOT_FOUND);
                            if (errorRoute != null) {
                                Flowable notFoundFlowable = Flowable.fromPublisher(this.buildResponsePublisher(req, (MutableHttpResponse<Object>)response, errorRoute, true));
                                return notFoundFlowable.onErrorReturn(throwable -> {
                                    if (LOG.isErrorEnabled()) {
                                        LOG.error("Error occuring invoking 404 handler: " + throwable.getMessage());
                                    }
                                    MutableHttpResponse defaultNotFound = res.status(404).body((Object)this.newJsonError(req, "Page Not Found"));
                                    this.encodeResponse(exchange, annotationMetadata, (HttpResponse<?>)defaultNotFound);
                                    return defaultNotFound;
                                });
                            }
                            return Publishers.just((Object)res.status(404).body((Object)this.newJsonError(req, "Page Not Found")));
                        }));
                    }
                    Flowable flowable = (Flowable)Publishers.convertPublisher((Object)body, Flowable.class);
                    if (isAsyncSupported) {
                        ServletHttpResponse servletResponse = exchange.getResponse();
                        this.setHeadersFromMetadata(exchange.getResponse(), annotationMetadata, body);
                        return servletResponse.stream((Publisher<?>)flowable);
                    }
                    return flowable.toList().map(list -> {
                        ServletHttpResponse servletHttpResponse = exchange.getResponse();
                        this.encodeResponse(exchange, annotationMetadata, (HttpResponse<?>)servletHttpResponse.body(list));
                        return servletHttpResponse;
                    }).toFlowable();
                }
                if (!isErrorRoute && status.getCode() >= 400 && (errorRoute = this.lookupStatusRoute(route, status)) != null) {
                    return this.buildErrorRouteHandler(exchange, req, (MutableHttpResponse<Object>)response, errorRoute);
                }
            }
            if (body != null && (responseEncoder = this.responseEncoders.get(bodyType = body.getClass())) != null) {
                return responseEncoder.encode(exchange, annotationMetadata, body);
            }
            if (!isErrorRoute && status.getCode() >= 400 && (errorRoute = this.lookupStatusRoute(route, status)) != null) {
                return this.buildErrorRouteHandler(exchange, req, (MutableHttpResponse<Object>)response, errorRoute);
            }
            return Flowable.fromCallable(() -> {
                this.encodeResponse(exchange, annotationMetadata, (HttpResponse<?>)response);
                return response;
            });
        }).onErrorResumeNext(throwable -> {
            this.handleException(req, res, route, isErrorRoute, (Throwable)throwable, exchange);
            return Flowable.error((Throwable)throwable);
        });
        if (isAsyncSupported) {
            Flowable.fromPublisher(exchangeRequest.subscribeOnExecutor((Publisher<MutableHttpResponse<?>>)responseFlowable)).subscribe(response -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request [{} - {}] completed successfully", (Object)req.getMethodName(), (Object)req.getUri());
                }
            }, throwable -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request [" + req.getMethodName() + " - " + req.getUri() + "] completed with error: " + throwable.getMessage(), throwable);
                }
            });
        } else {
            responseFlowable.blockingSubscribe(response -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request [{} - {}] completed successfully", (Object)req.getMethodName(), (Object)req.getUri());
                }
            }, throwable -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Request [" + req.getMethodName() + " - " + req.getUri() + "] completed with error: " + throwable.getMessage(), throwable);
                }
            });
        }
    }

    private Publisher<? extends MutableHttpResponse<?>> buildErrorRouteHandler(ServletExchange<Req, Res> exchange, HttpRequest<Object> request, MutableHttpResponse<Object> response, RouteMatch<Object> errorRoute) {
        return Publishers.map(this.buildResponsePublisher(request, response, errorRoute, true), servletResponse -> {
            this.encodeResponse(exchange, errorRoute.getAnnotationMetadata(), (HttpResponse<?>)servletResponse);
            return servletResponse;
        });
    }

    private Publisher<? extends MutableHttpResponse<?>> buildResponsePublisher(HttpRequest<Object> req, MutableHttpResponse<Object> res, RouteMatch<?> route, boolean isErrorRoute) {
        Flowable responsePublisher = Flowable.defer(() -> {
            ConvertibleValues convertibleValues;
            RouteMatch computedRoute = route;
            if (!computedRoute.isExecutable()) {
                computedRoute = this.requestArgumentSatisfier.fulfillArgumentRequirements(computedRoute, req, false);
            }
            if (!computedRoute.isExecutable() && HttpMethod.permitsRequestBody((HttpMethod)req.getMethod()) && !computedRoute.getBodyArgument().isPresent() && (convertibleValues = (ConvertibleValues)req.getBody(ConvertibleValues.class).orElse(null)) != null) {
                Collection requiredArguments = route.getRequiredArguments();
                HashMap newValues = new HashMap(requiredArguments.size());
                for (Argument requiredArgument : requiredArguments) {
                    String name = requiredArgument.getName();
                    convertibleValues.get((CharSequence)name, requiredArgument).ifPresent(v -> newValues.put(name, v));
                }
                if (CollectionUtils.isNotEmpty(newValues)) {
                    computedRoute = computedRoute.fulfill(newValues);
                }
            }
            RouteMatch finalComputedRoute = computedRoute;
            Object result = ServerRequestContext.with((HttpRequest)req, () -> ((RouteMatch)finalComputedRoute).execute());
            if (result instanceof Optional) {
                result = ((Optional)result).orElse(null);
            }
            MutableHttpResponse httpResponse = res;
            if (result instanceof MutableHttpResponse) {
                httpResponse = (MutableHttpResponse)result;
                result = httpResponse.body();
            }
            ReturnType returnType = computedRoute.getReturnType();
            Argument genericReturnType = returnType.asArgument();
            Class javaReturnType = returnType.getType();
            if (result == null) {
                boolean isVoid;
                boolean bl = isVoid = javaReturnType == Void.TYPE || Completable.class.isAssignableFrom(javaReturnType) || genericReturnType.getFirstTypeVariable().map(arg -> arg.getType() == Void.class).orElse(false) != false;
                if (isVoid) {
                    return Publishers.just((Object)httpResponse);
                }
                if (httpResponse.status() == HttpStatus.OK) {
                    httpResponse.status(HttpStatus.NOT_FOUND);
                }
                return Publishers.just((Object)httpResponse);
            }
            Argument firstArg = genericReturnType.getFirstTypeVariable().orElse(null);
            if (result instanceof Future) {
                if (result instanceof CompletionStage) {
                    CompletionStage cs = (CompletionStage)result;
                    result = Maybe.create(emitter -> cs.whenComplete((o, throwable) -> {
                        if (throwable != null) {
                            emitter.onError(throwable);
                        } else if (o != null) {
                            emitter.onSuccess(o);
                        } else {
                            emitter.onComplete();
                        }
                    }));
                } else {
                    result = Single.fromFuture((Future)((Future)result));
                }
            }
            if (firstArg != null && HttpResponse.class.isAssignableFrom(firstArg.getType()) && Publishers.isConvertibleToPublisher((Object)result)) {
                return (Publisher)Publishers.convertPublisher((Object)result, Flowable.class);
            }
            return Publishers.just((Object)httpResponse.body(result));
        });
        return this.filterPublisher(new AtomicReference(req), (Publisher<? extends MutableHttpResponse<?>>)responsePublisher, isErrorRoute);
    }

    private void encodeResponse(ServletExchange<Req, Res> exchange, AnnotationMetadata annotationMetadata, HttpResponse<?> response) {
        block65: {
            Object body = response.getBody().orElse(null);
            this.setHeadersFromMetadata(exchange.getResponse(), annotationMetadata, body);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending response {}", (Object)response.status());
                this.traceHeaders(response.getHeaders());
            }
            if (body instanceof HttpStatus) {
                exchange.getResponse().status((HttpStatus)body);
            } else {
                if (body instanceof CharSequence) {
                    if (response instanceof MutableHttpResponse && !response.getContentType().isPresent()) {
                        ((MutableHttpResponse)response).contentType(MediaType.TEXT_PLAIN_TYPE);
                    }
                    try (BufferedWriter writer = exchange.getResponse().getWriter();){
                        writer.write(body.toString());
                        writer.flush();
                        break block65;
                    }
                    catch (IOException e) {
                        throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
                    }
                }
                if (body instanceof byte[]) {
                    try (OutputStream outputStream = exchange.getResponse().getOutputStream();){
                        outputStream.write((byte[])body);
                        outputStream.flush();
                        break block65;
                    }
                    catch (IOException e) {
                        throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
                    }
                }
                if (body instanceof Writable) {
                    Writable writable = (Writable)body;
                    try (OutputStream outputStream = exchange.getResponse().getOutputStream();){
                        writable.writeTo(outputStream, response.getCharacterEncoding());
                        outputStream.flush();
                        break block65;
                    }
                    catch (IOException e) {
                        throw new HttpStatusException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
                    }
                }
                if (body != null) {
                    Class<?> bodyType = body.getClass();
                    MediaType ct = response.getContentType().orElseGet(() -> {
                        Object[] v;
                        Produces ann = bodyType.getAnnotation(Produces.class);
                        if (ann != null && ArrayUtils.isNotEmpty((Object[])(v = ann.value()))) {
                            MediaType mediaType = new MediaType((String)v[0]);
                            if (response instanceof MutableHttpResponse) {
                                ((MutableHttpResponse)response).contentType(mediaType);
                            }
                            return mediaType;
                        }
                        if (response instanceof MutableHttpResponse) {
                            ((MutableHttpResponse)response).contentType(MediaType.APPLICATION_JSON_TYPE);
                        }
                        return MediaType.APPLICATION_JSON_TYPE;
                    });
                    MediaTypeCodec codec = this.mediaTypeCodecRegistry.findCodec(ct, bodyType).orElse(null);
                    if (codec != null) {
                        try (OutputStream outputStream = exchange.getResponse().getOutputStream();){
                            codec.encode(body, outputStream);
                            outputStream.flush();
                            break block65;
                        }
                        catch (Throwable e) {
                            throw new CodecException("Failed to encode object [" + body + "] to content type [" + ct + "]: " + e.getMessage(), e);
                        }
                    }
                    throw new CodecException("No codec present capable of encoding object [" + body + "] to content type [" + ct + "]");
                }
            }
        }
    }

    private void setHeadersFromMetadata(MutableHttpResponse<Object> res, AnnotationMetadata annotationMetadata, Object result) {
        if (!res.getContentType().isPresent()) {
            String contentType = annotationMetadata.stringValue(Produces.class).orElse(this.getDefaultMediaType(result));
            if (contentType != null) {
                res.contentType((CharSequence)contentType);
            } else if (result instanceof CharSequence) {
                res.contentType((CharSequence)"text/plain");
            }
        }
        annotationMetadata.enumValue(Status.class, HttpStatus.class).ifPresent(arg_0 -> res.status(arg_0));
        List headers = annotationMetadata.getAnnotationValuesByType(Header.class);
        for (AnnotationValue header : headers) {
            String value = header.stringValue().orElse(null);
            String name = header.stringValue("name").orElse(null);
            if (name == null || value == null) continue;
            res.header((CharSequence)name, (CharSequence)value);
        }
    }

    private String getDefaultMediaType(Object result) {
        if (result instanceof CharSequence) {
            return "text/plain";
        }
        if (result != null) {
            return "application/json";
        }
        return null;
    }

    private void handleException(HttpRequest<Object> req, MutableHttpResponse<Object> res, RouteMatch<?> route, boolean isErrorRoute, Throwable e, ServletExchange<Req, Res> exchange) {
        req.setAttribute((CharSequence)HttpAttributes.ERROR, (Object)e);
        if (isErrorRoute) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error occurred executing Error route [" + route + "]: " + e.getMessage(), e);
            }
            res.status(HttpStatus.INTERNAL_SERVER_ERROR, (CharSequence)e.getMessage());
        } else if (e instanceof UnsatisfiedRouteException || e instanceof ConversionErrorException) {
            RouteMatch<Object> badRequestRoute = this.lookupStatusRoute(route, HttpStatus.BAD_REQUEST);
            if (badRequestRoute != null) {
                this.invokeRouteMatch(req, res, badRequestRoute, true, exchange);
            } else {
                this.invokeExceptionHandlerIfPossible(req, res, e, HttpStatus.BAD_REQUEST, exchange);
            }
        } else if (e instanceof HttpStatusException) {
            RouteMatch<Object> statusRoute;
            HttpStatusException statusException = (HttpStatusException)e;
            HttpStatus status = statusException.getStatus();
            int code = status.getCode();
            boolean isErrorStatus = code >= 400;
            RouteMatch<Object> routeMatch = statusRoute = isErrorStatus ? this.lookupStatusRoute(route, status) : null;
            if (statusRoute != null) {
                this.invokeRouteMatch(req, res, statusRoute, true, exchange);
            } else {
                this.emitError(exchange, res, req, emitter -> {
                    res.status(code, (CharSequence)statusException.getMessage());
                    Object body = statusException.getBody().orElse(null);
                    if (body != null) {
                        res.body(body);
                    } else if (isErrorStatus) {
                        res.body((Object)this.newJsonError(req, statusException.getMessage()));
                    }
                    emitter.onNext((Object)res);
                    emitter.onComplete();
                });
            }
        } else {
            RouteMatch<Object> errorRoute = this.lookupErrorRoute(route, e);
            if (errorRoute == null && e instanceof CodecException) {
                Throwable cause = e.getCause();
                if (cause != null) {
                    errorRoute = this.lookupErrorRoute(route, cause);
                }
                if (errorRoute == null) {
                    RouteMatch<Object> badRequestRoute = this.lookupStatusRoute(route, HttpStatus.BAD_REQUEST);
                    if (badRequestRoute != null) {
                        this.invokeRouteMatch(req, res, badRequestRoute, true, exchange);
                    } else {
                        this.invokeExceptionHandlerIfPossible(req, res, e, HttpStatus.BAD_REQUEST, exchange);
                    }
                    return;
                }
            }
            if (errorRoute != null) {
                this.invokeRouteMatch(req, res, errorRoute, true, exchange);
            } else {
                this.invokeExceptionHandlerIfPossible(req, res, e, HttpStatus.INTERNAL_SERVER_ERROR, exchange);
            }
        }
    }

    private void invokeExceptionHandlerIfPossible(HttpRequest<Object> req, MutableHttpResponse<Object> res, Throwable e, HttpStatus defaultStatus, ServletExchange<Req, Res> exchange) {
        ExceptionHandler<Throwable, ?> exceptionHandler = this.lookupExceptionHandler(e);
        if (exceptionHandler != null) {
            try {
                ServerRequestContext.with(req, () -> {
                    Object result = exceptionHandler.handle(req, e);
                    if (result instanceof MutableHttpResponse) {
                        this.encodeResponse(exchange, AnnotationMetadata.EMPTY_METADATA, (HttpResponse<?>)((MutableHttpResponse)result));
                    } else if (result != null) {
                        MutableHttpResponse response = exchange.getResponse().status(defaultStatus).body(result);
                        this.encodeResponse(exchange, AnnotationMetadata.EMPTY_METADATA, (HttpResponse<?>)response);
                    }
                });
            }
            catch (Throwable ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Error occurred executing exception handler [" + exceptionHandler.getClass() + "]: " + e.getMessage(), e);
                }
                this.emitError(exchange, res, req, emitter -> {
                    res.status(HttpStatus.INTERNAL_SERVER_ERROR, (CharSequence)e.getMessage());
                    emitter.onNext((Object)res);
                    emitter.onComplete();
                });
            }
        } else {
            if (defaultStatus.getCode() >= 500) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(defaultStatus.getReason() + ": " + e.getMessage(), e);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(defaultStatus.getReason() + ": " + e.getMessage(), e);
            }
            this.emitError(exchange, res, req, emitter -> {
                res.status(defaultStatus).body((Object)this.newJsonError(req, e.getMessage()));
                emitter.onNext((Object)res);
                emitter.onComplete();
            });
        }
    }

    private JsonError newJsonError(HttpRequest<Object> req, String message) {
        JsonError jsonError = new JsonError(message);
        jsonError.link((CharSequence)"self", req.getPath());
        return jsonError;
    }

    private ExceptionHandler<Throwable, ?> lookupExceptionHandler(Throwable e) {
        Class<?> type = e.getClass();
        return this.applicationContext.findBean(ExceptionHandler.class, Qualifiers.byTypeArgumentsClosest((Class[])new Class[]{type, HttpResponse.class})).orElse(null);
    }

    private RouteMatch<Object> lookupErrorRoute(RouteMatch<?> route, Throwable e) {
        if (route == null) {
            return this.router.route(e).orElse(null);
        }
        return this.router.route(route.getDeclaringType(), e).orElseGet(() -> this.router.route(e).orElse(null));
    }

    private RouteMatch<Object> lookupStatusRoute(RouteMatch<?> route, HttpStatus status) {
        if (route == null) {
            return this.router.route(status).orElse(null);
        }
        return this.router.route(route.getDeclaringType(), status).orElseGet(() -> this.router.route(status).orElse(null));
    }

    private Publisher<? extends MutableHttpResponse<?>> filterPublisher(final AtomicReference<HttpRequest<?>> requestReference, Publisher<? extends MutableHttpResponse<?>> routePublisher, boolean skipOncePerRequest) {
        Publisher finalPublisher;
        final ArrayList<Object> filters = new ArrayList<Object>(this.router.findFilters(requestReference.get()));
        if (filters.isEmpty()) {
            return routePublisher;
        }
        if (skipOncePerRequest) {
            filters.removeIf(filter -> filter instanceof OncePerRequestHttpServerFilter);
        }
        if (!filters.isEmpty()) {
            Publisher resultingPublisher;
            filters.add((req, chain) -> routePublisher);
            final AtomicInteger integer = new AtomicInteger();
            final int len = filters.size();
            ServerFilterChain filterChain = new ServerFilterChain(){

                public Publisher<MutableHttpResponse<?>> proceed(HttpRequest<?> request) {
                    int pos = integer.incrementAndGet();
                    if (pos > len) {
                        throw new IllegalStateException("The FilterChain.proceed(..) method should be invoked exactly once per filter execution. The method has instead been invoked multiple times by an erroneous filter definition.");
                    }
                    HttpFilter httpFilter = (HttpFilter)filters.get(pos);
                    return httpFilter.doFilter(requestReference.getAndSet(request), (FilterChain)this);
                }
            };
            HttpFilter httpFilter = (HttpFilter)filters.get(0);
            HttpRequest<?> req2 = requestReference.get();
            finalPublisher = resultingPublisher = (Publisher)ServerRequestContext.with(req2, () -> httpFilter.doFilter(req2, (FilterChain)filterChain));
        } else {
            finalPublisher = routePublisher;
        }
        return finalPublisher;
    }
}

