/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequestWrapper;
import io.micronaut.servlet.http.ServletHttpRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;

@Internal
final class ServletRequestAndBody<N, B>
extends HttpRequestWrapper<B>
implements ServletHttpRequest<N, B> {
    private final Argument<B> bodyType;

    ServletRequestAndBody(ServletHttpRequest<N, B> delegate, Argument<B> bodyType) {
        super(delegate);
        this.bodyType = Objects.requireNonNull(bodyType, "Body type cannot be null");
    }

    @Override
    public boolean isAsyncSupported() {
        return ((ServletHttpRequest)this.getDelegate()).isAsyncSupported();
    }

    public Optional<B> getBody() {
        return this.getBody(this.bodyType);
    }

    @Override
    public String getContextPath() {
        return ((ServletHttpRequest)this.getDelegate()).getContextPath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return ((ServletHttpRequest)this.getDelegate()).getInputStream();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return ((ServletHttpRequest)this.getDelegate()).getReader();
    }

    @Override
    public N getNativeRequest() {
        return ((ServletHttpRequest)this.getDelegate()).getNativeRequest();
    }
}

