/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletRequestAndBody;
import java.util.Optional;

@Internal
class ServletRequestBinder
implements TypedRequestArgumentBinder<HttpRequest> {
    private final MediaTypeCodecRegistry mediaTypeCodecRegistry;

    ServletRequestBinder(MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        this.mediaTypeCodecRegistry = mediaTypeCodecRegistry;
    }

    public Argument<HttpRequest> argumentType() {
        return Argument.of(HttpRequest.class);
    }

    public ArgumentBinder.BindingResult<HttpRequest> bind(ArgumentConversionContext<HttpRequest> context, HttpRequest<?> source) {
        if (source instanceof ServletHttpRequest) {
            ServletHttpRequest serverlessHttpRequest = (ServletHttpRequest)source;
            long contentLength = serverlessHttpRequest.getContentLength();
            Argument bodyType = context.getArgument().getFirstTypeVariable().orElse(null);
            if (bodyType != null && contentLength != 0L) {
                return () -> Optional.of(new ServletRequestAndBody(serverlessHttpRequest, bodyType));
            }
        }
        return () -> Optional.of(source);
    }
}

