/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http;

import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponseFactory;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.server.exceptions.InternalServerException;
import io.micronaut.http.simple.SimpleHttpResponseFactory;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpResponse;

public class ServletResponseFactory
implements HttpResponseFactory {
    private static final HttpResponseFactory ALTERNATE;

    public <T> MutableHttpResponse<T> ok(T body) {
        HttpRequest req = ServerRequestContext.currentRequest().orElse(null);
        if (req instanceof ServletExchange) {
            ServletHttpResponse response = ((ServletExchange)req).getResponse();
            return response.status(HttpStatus.OK).body(body);
        }
        if (ALTERNATE != null) {
            return ALTERNATE.ok(body);
        }
        throw new InternalServerException("No request present");
    }

    public <T> MutableHttpResponse<T> status(HttpStatus status, String reason) {
        HttpRequest req = ServerRequestContext.currentRequest().orElse(null);
        if (req instanceof ServletExchange) {
            ServletHttpResponse response = ((ServletExchange)req).getResponse();
            return response.status(status, reason);
        }
        if (ALTERNATE != null) {
            return ALTERNATE.status(status, reason);
        }
        throw new InternalServerException("No request present");
    }

    public <T> MutableHttpResponse<T> status(HttpStatus status, T body) {
        HttpRequest req = ServerRequestContext.currentRequest().orElse(null);
        if (req instanceof ServletExchange) {
            ServletHttpResponse response = ((ServletExchange)req).getResponse();
            return response.status(status).body(body);
        }
        if (ALTERNATE != null) {
            return ALTERNATE.status(status, body);
        }
        throw new InternalServerException("No request present");
    }

    static {
        SoftServiceLoader factories = SoftServiceLoader.load(HttpResponseFactory.class);
        HttpResponseFactory alternate = null;
        for (ServiceDefinition factory : factories) {
            if (!factory.isPresent() || factory.getName().equals(ServletResponseFactory.class.getName())) continue;
            alternate = (HttpResponseFactory)factory.load();
            break;
        }
        ALTERNATE = alternate != null ? alternate : new SimpleHttpResponseFactory();
    }
}

