/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http.encoders;

import io.micronaut.http.HttpHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.types.files.FileCustomizableResponseType;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.micronaut.servlet.http.ServletResponseEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;

public abstract class AbstractFileEncoder<T extends FileCustomizableResponseType>
implements ServletResponseEncoder<T> {
    protected MutableHttpResponse<?> setDateHeader(MutableHttpResponse<?> response) {
        MutableHttpHeaders headers = response.getHeaders();
        LocalDateTime now = LocalDateTime.now();
        headers.date(now);
        return response;
    }

    protected void setDateAndCacheHeaders(MutableHttpResponse response, long lastModified) {
        MutableHttpHeaders headers = response.getHeaders();
        LocalDateTime now = LocalDateTime.now();
        headers.date(now);
        LocalDateTime cacheSeconds = now.plus(60L, ChronoUnit.SECONDS);
        if (response.header((CharSequence)"Expires") == null) {
            headers.expires(cacheSeconds);
        }
        if (response.header((CharSequence)"Cache-Control") == null) {
            String header = "private, max-age=60";
            response.header((CharSequence)"Cache-Control", (CharSequence)header);
        }
        if (response.header((CharSequence)"Last-Modified") == null) {
            headers.lastModified(lastModified);
        }
    }

    protected boolean ifNotModified(@Nonnull T value, ServletHttpRequest<?, ? super Object> request, ServletHttpResponse<?, ? super Object> response) {
        long fileLastModifiedSeconds;
        long ifModifiedSinceDateSeconds;
        ZonedDateTime ifModifiedSince;
        long lastModified = value.getLastModified();
        HttpHeaders headers = request.getHeaders();
        MediaType mediaType = value.getMediaType();
        if (mediaType != null && !response.getContentType().isPresent()) {
            response.header("Content-Type", (CharSequence)mediaType);
        }
        if ((ifModifiedSince = headers.getDate((CharSequence)"If-Modified-Since")) != null && (ifModifiedSinceDateSeconds = ifModifiedSince.toEpochSecond()) == (fileLastModifiedSeconds = lastModified / 1000L)) {
            return true;
        }
        if (!response.getHeaders().contains("Content-Type")) {
            response.header("Content-Type", value.getMediaType().toString());
        }
        this.setDateAndCacheHeaders(response, lastModified);
        long length = value.getLength();
        if (length > -1L) {
            response.header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, String.valueOf(length));
        } else {
            response.header((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (CharSequence)HttpHeaderValues.CHUNKED);
        }
        value.process(response);
        return false;
    }
}

