/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http.encoders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.types.files.StreamedFile;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.micronaut.servlet.http.encoders.AbstractFileEncoder;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
public class StreamFileEncoder
extends AbstractFileEncoder<StreamedFile> {
    @Override
    public Class<StreamedFile> getResponseType() {
        return StreamedFile.class;
    }

    @Override
    public Publisher<MutableHttpResponse<?>> encode(@Nonnull ServletExchange<?, ?> exchange, AnnotationMetadata annotationMetadata, @Nonnull StreamedFile value) {
        ServletHttpResponse<?, Object> response;
        ServletHttpRequest<?, Object> request = exchange.getRequest();
        if (this.ifNotModified(value, request, response = exchange.getResponse())) {
            return Publishers.just(this.setDateHeader(response.status(HttpStatus.NOT_MODIFIED)));
        }
        boolean asyncSupported = request.isAsyncSupported();
        if (asyncSupported) {
            return response.stream((Publisher<?>)Flowable.create(emitter -> {
                try (InputStream in = value.getInputStream();){
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer)) != -1) {
                        if (buffer.length == len) {
                            emitter.onNext((Object)buffer);
                            continue;
                        }
                        emitter.onNext((Object)Arrays.copyOf(buffer, len));
                    }
                    emitter.onComplete();
                }
                catch (Throwable e) {
                    emitter.onError(e);
                }
            }, (BackpressureStrategy)BackpressureStrategy.BUFFER));
        }
        return Flowable.fromCallable(() -> {
            try (InputStream in = value.getInputStream();
                 OutputStream out = response.getOutputStream();){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            return response;
        });
    }
}

