/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.servlet.http.encoders;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.server.types.files.SystemFile;
import io.micronaut.servlet.http.ServletExchange;
import io.micronaut.servlet.http.ServletHttpRequest;
import io.micronaut.servlet.http.ServletHttpResponse;
import io.micronaut.servlet.http.encoders.AbstractFileEncoder;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
public class SystemFileEncoder
extends AbstractFileEncoder<SystemFile> {
    @Override
    public Class<SystemFile> getResponseType() {
        return SystemFile.class;
    }

    @Override
    public Publisher<MutableHttpResponse<?>> encode(@Nonnull ServletExchange<?, ?> exchange, AnnotationMetadata annotationMetadata, @Nonnull SystemFile value) {
        ServletHttpResponse<?, Object> response;
        ServletHttpRequest<?, Object> request = exchange.getRequest();
        if (this.ifNotModified(value, request, response = exchange.getResponse())) {
            return Publishers.just(this.setDateHeader(response.status(HttpStatus.NOT_MODIFIED)));
        }
        boolean asyncSupported = exchange.getRequest().isAsyncSupported();
        if (asyncSupported) {
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(value.getFile(), "r");
                return response.stream((Publisher<?>)Flowable.create(emitter -> {
                    ByteBuffer buf = ByteBuffer.allocate(1024);
                    try (FileChannel channel = randomAccessFile.getChannel();){
                        while (channel.read(buf) > 0) {
                            byte[] bytes = buf.array();
                            int p = buf.position();
                            if (p == 1024) {
                                emitter.onNext((Object)buf.array());
                            } else {
                                emitter.onNext((Object)Arrays.copyOf(bytes, p));
                            }
                            buf.clear();
                        }
                    }
                    catch (Throwable e) {
                        emitter.onError(e);
                    }
                }, (BackpressureStrategy)BackpressureStrategy.BUFFER));
            }
            catch (FileNotFoundException e) {
                return Publishers.just((Object)response.status(HttpStatus.NOT_FOUND));
            }
        }
        return Flowable.fromCallable(() -> {
            try (FileInputStream in = new FileInputStream(value.getFile());
                 OutputStream out = response.getOutputStream();){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = ((InputStream)in).read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            return response;
        });
    }
}

