/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.boot;

import io.micronaut.context.event.StartupEvent;
import io.micronaut.core.cli.CommandLine;
import java.util.List;
import javax.inject.Singleton;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.context.event.EventListener;

@Singleton
public class ApplicationRunnerListener {
    private final CommandLine commandLine;
    private final List<CommandLineRunner> commandLineRunnerList;
    private final List<ApplicationRunner> applicationRunnerList;

    protected ApplicationRunnerListener(CommandLine commandLine, List<CommandLineRunner> commandLineRunnerList, List<ApplicationRunner> applicationRunnerList) {
        this.commandLine = commandLine;
        this.commandLineRunnerList = commandLineRunnerList;
        this.applicationRunnerList = applicationRunnerList;
    }

    @EventListener
    protected void onStartup(StartupEvent startupEvent) {
        for (CommandLineRunner runner : this.commandLineRunnerList) {
            try {
                runner.run(this.commandLine.getRawArguments());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute ApplicationRunner", e);
            }
        }
        for (ApplicationRunner applicationRunner : this.applicationRunnerList) {
            try {
                applicationRunner.run((ApplicationArguments)new DefaultApplicationArguments(this.commandLine.getRawArguments()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to execute ApplicationRunner", e);
            }
        }
    }
}

