/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.annotation;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Delete;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Head;
import io.micronaut.http.annotation.HttpMethodMapping;
import io.micronaut.http.annotation.Options;
import io.micronaut.http.annotation.Patch;
import io.micronaut.http.annotation.Post;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.annotation.Put;
import io.micronaut.http.annotation.Trace;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.spring.annotation.AbstractSpringAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RequestMappingAnnotationMapper
extends AbstractSpringAnnotationMapper {
    public String getName() {
        return "org.springframework.web.bind.annotation.RequestMapping";
    }

    protected List<AnnotationValue<?>> mapInternal(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        ArrayList annotations = new ArrayList();
        String path = this.computePath(annotation);
        Optional method = annotation.get((CharSequence)"method", HttpMethod.class);
        annotations.add(this.newBuilder(method.orElse(null), annotation).value(path).build());
        Object[] consumes = annotation.get((CharSequence)"consumes", String[].class).orElse(null);
        Object[] produces = annotation.get((CharSequence)"produces", String[].class).orElse(null);
        if (ArrayUtils.isNotEmpty((Object[])consumes)) {
            annotations.add(AnnotationValue.builder(Consumes.class).member("value", (String[])consumes).build());
        }
        if (ArrayUtils.isNotEmpty((Object[])produces)) {
            annotations.add(AnnotationValue.builder(Produces.class).member("value", (String[])produces).build());
        }
        if (this.isHttpMethodMapping(method.orElse(null))) {
            annotations.add(AnnotationValue.builder(HttpMethodMapping.class).value(path).build());
        }
        return annotations;
    }

    protected boolean isHttpMethodMapping(@Nullable HttpMethod method) {
        return method != null;
    }

    @Nonnull
    protected AnnotationValueBuilder<?> newBuilder(@Nullable HttpMethod httpMethod, AnnotationValue<Annotation> annotation) {
        if (httpMethod != null) {
            switch (httpMethod) {
                case TRACE: {
                    return AnnotationValue.builder(Trace.class);
                }
                case DELETE: {
                    return AnnotationValue.builder(Delete.class);
                }
                case GET: {
                    return AnnotationValue.builder(Get.class);
                }
                case HEAD: {
                    return AnnotationValue.builder(Head.class);
                }
                case POST: {
                    return AnnotationValue.builder(Post.class);
                }
                case PUT: {
                    return AnnotationValue.builder(Put.class);
                }
                case PATCH: {
                    return AnnotationValue.builder(Patch.class);
                }
                case OPTIONS: {
                    return AnnotationValue.builder(Options.class);
                }
            }
            return AnnotationValue.builder((String)"io.micronaut.http.annotation.UriMapping");
        }
        return AnnotationValue.builder((String)"io.micronaut.http.annotation.UriMapping");
    }

    private String computePath(AnnotationValue<Annotation> annotation) {
        return annotation.getValue(String.class).orElseGet(() -> annotation.get((CharSequence)"path", String.class).orElse("/"));
    }
}

