/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.spring.web.annotation;

import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.spring.annotation.AbstractSpringAnnotationMapper;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class WebBindAnnotationMapper<T extends Annotation>
extends AbstractSpringAnnotationMapper {
    @Nonnull
    abstract Class<T> annotationType();

    protected List<AnnotationValue<?>> mapInternal(AnnotationValue<Annotation> annotation, VisitorContext visitorContext) {
        ArrayList mappedAnnotations = new ArrayList();
        String name = annotation.getValue(String.class).orElseGet(() -> annotation.get((CharSequence)"name", String.class).orElse(null));
        String defaultValue = annotation.get((CharSequence)"defaultValue", String.class).orElse(null);
        boolean required = annotation.get((CharSequence)"required", Boolean.TYPE).orElse(true);
        AnnotationValueBuilder builder = AnnotationValue.builder(this.annotationType());
        AnnotationValueBuilder bindableBuilder = AnnotationValue.builder(Bindable.class);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            builder.value(name);
            bindableBuilder.value(name);
        }
        if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
            builder.member("defaultValue", name);
            bindableBuilder.member("defaultValue", defaultValue);
        }
        mappedAnnotations.add(builder.build());
        mappedAnnotations.add(bindableBuilder.build());
        if (!required) {
            mappedAnnotations.add(AnnotationValue.builder(Nullable.class).build());
        }
        return mappedAnnotations;
    }
}

