/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.extensions;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextBuilder;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.env.PropertySourceLoader;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.core.io.service.ServiceDefinition;
import io.micronaut.core.io.service.SoftServiceLoader;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.runtime.EmbeddedApplication;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.context.scope.refresh.RefreshScope;
import io.micronaut.test.annotation.AnnotationUtils;
import io.micronaut.test.annotation.MicronautTest;
import io.micronaut.test.support.TestPropertyProvider;
import io.micronaut.test.transaction.TestTransactionInterceptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public abstract class AbstractMicronautExtension<C>
implements TestTransactionInterceptor {
    public static final String DISABLED_MESSAGE = "Test is not bean. Either the test does not satisfy requirements defined by @Requires or annotation processing is not enabled. If the latter ensure annotation processing is enabled in your IDE.";
    public static final String MISCONFIGURED_MESSAGE = "@MicronautTest used on test but no bean definition for the test present. This error indicates a misconfigured build or IDE. Please add the 'micronaut-inject-java' annotation processor to your test processor path (for Java this is the testAnnotationProcessor scope, for Kotlin kaptTest and for Groovy testCompile). See the documentation for reference: https://micronaut-projects.github.io/micronaut-test/latest/guide/";
    private static Map<String, PropertySourceLoader> loaderMap;
    protected ApplicationContext applicationContext;
    protected EmbeddedApplication embeddedApplication;
    protected RefreshScope refreshScope;
    protected BeanDefinition<?> specDefinition;
    protected Map<String, Object> testProperties = new LinkedHashMap<String, Object>();
    protected Map<String, Object> oldValues = new LinkedHashMap<String, Object>();
    private boolean rollback = true;
    private boolean transactional = true;

    @Override
    public void begin() {
        if (this.transactional && this.applicationContext != null) {
            Collection interceptors = this.applicationContext.getBeansOfType(TestTransactionInterceptor.class);
            for (TestTransactionInterceptor interceptor : interceptors) {
                interceptor.begin();
            }
        }
    }

    @Override
    public void commit() {
        if (this.transactional && this.applicationContext != null && !this.rollback) {
            Collection interceptors = this.applicationContext.getBeansOfType(TestTransactionInterceptor.class);
            for (TestTransactionInterceptor interceptor : interceptors) {
                interceptor.commit();
            }
        }
    }

    @Override
    public void rollback() {
        if (this.transactional && this.applicationContext != null && this.rollback) {
            Collection interceptors = this.applicationContext.getBeansOfType(TestTransactionInterceptor.class);
            for (TestTransactionInterceptor interceptor : interceptors) {
                interceptor.rollback();
            }
        }
    }

    protected void beforeClass(C context, Class<?> testClass, @Nullable MicronautTest testAnnotation) {
        if (testAnnotation != null) {
            String[] environments;
            this.rollback = testAnnotation.rollback();
            this.transactional = testAnnotation.transactional();
            ApplicationContextBuilder builder = ApplicationContext.build();
            Package aPackage = testClass.getPackage();
            builder.packages(new String[]{aPackage.getName()});
            List<Property> ps = AnnotationUtils.findRepeatableAnnotations(testClass, Property.class);
            for (Property property : ps) {
                this.testProperties.put(property.name(), property.value());
            }
            Object[] propertySources = testAnnotation.propertySources();
            if (ArrayUtils.isNotEmpty((Object[])propertySources)) {
                Map<String, PropertySourceLoader> loaderMap = this.readPropertySourceLoaderMap();
                ResourceResolver resourceResolver = new ResourceResolver();
                for (Object propertySource : propertySources) {
                    Optional resourceAsStream;
                    InputStream inputStream;
                    String ext = NameUtils.extension((String)propertySource);
                    if (!StringUtils.isNotEmpty((CharSequence)ext)) continue;
                    String filename = NameUtils.filename((String)propertySource);
                    PropertySourceLoader loader = loaderMap.get(ext);
                    if (loader == null || (inputStream = (resourceAsStream = resourceResolver.getResourceAsStream((String)propertySource)).orElse(testClass.getResourceAsStream((String)propertySource))) == null) continue;
                    try {
                        Map properties = loader.read(filename, inputStream);
                        builder.propertySources(new PropertySource[]{PropertySource.of((String)filename, (Map)properties)});
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error loading property source reference for @MicronautTest: " + filename);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (TestPropertyProvider.class.isAssignableFrom(testClass)) {
                this.resolveTestProperties(context, testAnnotation, this.testProperties);
            }
            this.testProperties.put("micronaut.test.active.spec", aPackage.getName() + "." + testClass.getSimpleName());
            this.testProperties.put("micronaut.test.active.spec.clazz", testClass);
            Class<?> application = testAnnotation.application();
            if (application != Void.TYPE) {
                builder.mainClass(application);
            }
            if ((environments = testAnnotation.environments()).length == 0) {
                environments = new String[]{"test"};
            }
            builder.packages(testAnnotation.packages()).environments(environments);
            builder.propertySources(new PropertySource[]{PropertySource.of(this.testProperties)});
            this.applicationContext = builder.build();
            this.startApplicationContext();
            this.specDefinition = this.applicationContext.findBeanDefinition(testClass).orElse(null);
            if (this.applicationContext.containsBean(EmbeddedApplication.class)) {
                this.embeddedApplication = (EmbeddedApplication)this.applicationContext.getBean(EmbeddedApplication.class);
                this.embeddedApplication.start();
            }
            this.refreshScope = this.applicationContext.findBean(RefreshScope.class).orElse(null);
        }
    }

    protected abstract void resolveTestProperties(C var1, MicronautTest var2, Map<String, Object> var3);

    protected void beforeEach(C context, @Nullable Object testInstance, @Nullable AnnotatedElement method) {
        if (method != null) {
            Property[] ps = (Property[])method.getAnnotationsByType(Property.class);
            if (ps != null) {
                for (Property property : ps) {
                    String name = property.name();
                    this.oldValues.put(name, this.testProperties.put(name, property.value()));
                }
            }
            if (!this.oldValues.isEmpty()) {
                Map diff = this.applicationContext.getEnvironment().refreshAndDiff();
                this.refreshScope.onRefreshEvent(new RefreshEvent(diff));
            }
        }
        if (testInstance != null && this.applicationContext != null) {
            if (this.refreshScope != null) {
                this.refreshScope.onRefreshEvent(new RefreshEvent(Collections.singletonMap("micronaut.test.spock.active.mocks", "changed")));
            }
            this.applicationContext.inject(testInstance);
            this.alignMocks(context, testInstance);
        }
    }

    protected void afterClass(C context) {
        if (this.embeddedApplication != null) {
            this.embeddedApplication.stop();
        } else if (this.applicationContext != null) {
            this.applicationContext.stop();
        }
        this.embeddedApplication = null;
        this.applicationContext = null;
    }

    public void afterEach(C context) {
        if (this.refreshScope != null && !this.oldValues.isEmpty()) {
            this.testProperties.putAll(this.oldValues);
            Map diff = this.applicationContext.getEnvironment().refreshAndDiff();
            this.refreshScope.onRefreshEvent(new RefreshEvent(diff));
        }
        this.oldValues.clear();
    }

    protected void startApplicationContext() {
        this.applicationContext.start();
    }

    protected boolean isTestSuiteBeanPresent(Class<?> requiredTestClass) {
        return ClassUtils.isPresent((String)(requiredTestClass.getPackage().getName() + ".$" + requiredTestClass.getSimpleName() + "Definition"), (ClassLoader)requiredTestClass.getClassLoader());
    }

    protected abstract void alignMocks(C var1, Object var2);

    private Map<String, PropertySourceLoader> readPropertySourceLoaderMap() {
        Map<String, PropertySourceLoader> loaderMap = AbstractMicronautExtension.loaderMap;
        if (loaderMap == null) {
            AbstractMicronautExtension.loaderMap = loaderMap = new HashMap<String, PropertySourceLoader>();
            SoftServiceLoader loaders = SoftServiceLoader.load(PropertySourceLoader.class);
            for (ServiceDefinition loader : loaders) {
                if (!loader.isPresent()) continue;
                PropertySourceLoader psl = (PropertySourceLoader)loader.load();
                Set extensions = psl.getExtensions();
                for (String extension : extensions) {
                    loaderMap.put(extension, psl);
                }
            }
        }
        return loaderMap;
    }
}

