/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.transaction.spring;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.test.context.TestContext;
import io.micronaut.test.context.TestExecutionListener;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Requirements(value={@Requires(classes={PlatformTransactionManager.class}), @Requires(property="micronaut.test.transactional", value="true", defaultValue="true")})
@EachBean(value=PlatformTransactionManager.class)
public class SpringTransactionTestExecutionListener
implements TestExecutionListener {
    private final PlatformTransactionManager transactionManager;
    private TransactionStatus tx;
    private final AtomicInteger counter = new AtomicInteger();
    private final boolean rollback;

    public SpringTransactionTestExecutionListener(PlatformTransactionManager transactionManager, @Property(name="micronaut.test.rollback", defaultValue="true") boolean rollback) {
        this.transactionManager = transactionManager;
        this.rollback = rollback;
    }

    @Override
    public void beforeSetupTest(TestContext testContext) {
        this.beforeTestExecution(testContext);
    }

    @Override
    public void afterSetupTest(TestContext testContext) {
        this.afterTestExecution(false);
    }

    @Override
    public void beforeCleanupTest(TestContext testContext) throws Exception {
        this.beforeTestExecution(testContext);
    }

    @Override
    public void afterCleanupTest(TestContext testContext) throws Exception {
        this.afterTestExecution(false);
    }

    @Override
    public void afterTestExecution(TestContext testContext) {
        this.afterTestExecution(this.rollback);
    }

    @Override
    public void beforeTestExecution(TestContext testContext) {
        if (this.counter.getAndIncrement() == 0) {
            this.tx = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        }
    }

    private void afterTestExecution(boolean rollback) {
        if (this.counter.decrementAndGet() == 0) {
            if (rollback) {
                this.transactionManager.rollback(this.tx);
            } else {
                this.transactionManager.commit(this.tx);
            }
        }
    }
}

