/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.condition;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.test.annotation.MockBean;
import java.util.Optional;

public class TestActiveCondition
implements Condition {
    public static final String ACTIVE_MOCKS = "micronaut.test.spock.active.mocks";
    @Deprecated
    public static final String ACTIVE_SPEC_NAME = "micronaut.test.active.spec";
    public static final String ACTIVE_SPEC_CLAZZ = "micronaut.test.active.spec.clazz";

    public boolean matches(ConditionContext context) {
        if (context.getComponent() instanceof BeanDefinition) {
            BeanDefinition definition = (BeanDefinition)context.getComponent();
            BeanContext beanContext = context.getBeanContext();
            Optional declaringType = definition.getDeclaringType();
            if (beanContext instanceof ApplicationContext) {
                ApplicationContext applicationContext = (ApplicationContext)beanContext;
                Class activeSpecClazz = applicationContext.get((CharSequence)ACTIVE_SPEC_CLAZZ, Class.class).orElse(null);
                String activeSpecName = Optional.ofNullable(activeSpecClazz).map(clazz -> clazz.getPackage().getName() + "." + clazz.getSimpleName()).orElse(null);
                if (definition.isAnnotationPresent(MockBean.class) && declaringType.isPresent()) {
                    Class declaringTypeClass = (Class)declaringType.get();
                    String declaringTypeName = declaringTypeClass.getName();
                    if (activeSpecClazz != null) {
                        if (definition.isProxy()) {
                            String packageName = NameUtils.getPackageName((String)activeSpecName);
                            String simpleName = NameUtils.getSimpleName((String)activeSpecName);
                            String rootName = packageName + ".$" + simpleName;
                            return declaringTypeClass.isAssignableFrom(activeSpecClazz) || declaringTypeName.equals(rootName) || declaringTypeName.startsWith(rootName + "$");
                        }
                        return declaringTypeClass.isAssignableFrom(activeSpecClazz) || activeSpecName.equals(declaringTypeName) || declaringTypeName.startsWith(activeSpecName + "$");
                    }
                    context.fail("@MockBean of type " + definition.getBeanType() + " not within scope of parent test.");
                    return false;
                }
                if (activeSpecName != null) {
                    boolean beanTypeMatches = activeSpecName.equals(definition.getBeanType().getName());
                    return beanTypeMatches || declaringType.isPresent() && activeSpecClazz == declaringType.get();
                }
                return false;
            }
            return false;
        }
        return true;
    }
}

