/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.support.server;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.io.socket.SocketUtils;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.server.EmbeddedServer;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

@Primary
@Requirements(value={@Requires(property="micronaut.test.server.executable"), @Requires(beans={HttpServerConfiguration.class})})
@Singleton
public class TestExecutableEmbeddedServer
implements EmbeddedServer {
    public static final String PROPERTY = "micronaut.test.server.executable";
    private final String executable;
    private final ApplicationContext applicationContext;
    private final HttpServerConfiguration httpServerConfiguration;
    private final Environment environment;
    private int port;
    private Process process;

    @Internal
    protected TestExecutableEmbeddedServer(@Property(name="micronaut.test.server.executable") String executable, ApplicationContext applicationContext, HttpServerConfiguration httpServerConfiguration) {
        this.executable = executable;
        if (!new File(executable).exists()) {
            throw new ConfigurationException("No executable server exists at path: " + executable);
        }
        this.environment = applicationContext.getEnvironment();
        this.applicationContext = applicationContext;
        this.httpServerConfiguration = httpServerConfiguration;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return "localhost";
    }

    public String getScheme() {
        return "http";
    }

    public URL getURL() {
        try {
            return this.getURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid Configured Server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        return URI.create(this.getScheme() + "://" + this.getHost() + ":" + this.getPort());
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.httpServerConfiguration.getApplicationConfiguration();
    }

    public boolean isRunning() {
        return this.process != null;
    }

    public EmbeddedServer start() {
        if (this.process == null) {
            PropertySource testPropertySource = this.environment.getPropertySources().stream().filter(ps -> ps.getName().equals("test-properties")).findFirst().orElse(null);
            CompletableFuture processFuture = new CompletableFuture();
            Integer p = this.httpServerConfiguration.getPort().orElse(null);
            int port = p == null ? (this.environment.getActiveNames().contains("test") ? SocketUtils.findAvailableTcpPort() : 8080) : (p == -1 ? SocketUtils.findAvailableTcpPort() : p);
            new Thread(() -> {
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
                ArrayList<String> commandArgs = new ArrayList<String>(Arrays.asList("-Dmicronaut.environments=test", "-Dmicronaut.server.host=localhost", "-Dmicronaut.server.port=" + port));
                if (this.executable.endsWith(".jar")) {
                    commandArgs.addAll(0, Arrays.asList("java", "-jar", this.executable));
                } else {
                    commandArgs.add(0, this.executable);
                }
                if (testPropertySource != null) {
                    for (String prop : testPropertySource) {
                        commandArgs.add("-D" + prop + "=" + testPropertySource.get(prop));
                    }
                }
                processBuilder.command(commandArgs);
                processBuilder.inheritIO();
                try {
                    Process start = processBuilder.start();
                    processFuture.complete(start);
                }
                catch (IOException e) {
                    processFuture.completeExceptionally(new RuntimeException("Error starting native image server: " + e.getMessage(), e));
                }
            }).start();
            try {
                this.process = (Process)processFuture.get();
                int max = 10000;
                int timeout = 0;
                while (timeout < max) {
                    try {
                        URLConnection urlConnection = new URL("http://localhost:" + port).openConnection();
                        urlConnection.setConnectTimeout(max);
                        urlConnection.setReadTimeout(max);
                        BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                        in.readLine();
                        in.close();
                    }
                    catch (IOException e) {
                        if (e instanceof FileNotFoundException) break;
                        if ((timeout += 100) < max) {
                            Thread.sleep(100L);
                            continue;
                        }
                        throw new ServerStartupException("Timeout occurred starting Micronaut process server");
                    }
                }
                this.port = port;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new ServerStartupException(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    public EmbeddedServer stop() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        return this;
    }
}

