/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.support.sql;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.test.support.sql.SqlAnnotationHandlingException;
import io.micronaut.test.support.sql.SqlHandler;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Internal
@Requires(classes={DataSource.class})
public class DataSourceSqlHandler
implements SqlHandler<DataSource> {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceSqlHandler.class);

    @Override
    public void handle(@NonNull DataSource dataSource, @NonNull String sql) {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Executing SQL: {}", (Object)dataSource, (Object)sql);
            }
            statement.execute(sql);
        }
        catch (SQLException sqlException) {
            throw new SqlAnnotationHandlingException(sqlException);
        }
    }
}

