/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.test.support.sql;

import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.ResourceLoader;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.test.annotation.Sql;
import io.micronaut.test.support.sql.SqlHandler;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class TestSqlAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TestSqlAnnotationHandler.class);

    private TestSqlAnnotationHandler() {
    }

    public static void handle(BeanDefinition<?> specDefinition, ApplicationContext applicationContext, Sql.Phase phase) throws IOException {
        ResourceLoader resourceLoader = (ResourceLoader)applicationContext.getBean(ResourceLoader.class);
        Optional<List> sqlAnnotations = specDefinition.findAnnotation(Sql.Sqls.class).map(s -> s.getAnnotations("value", Sql.class));
        if (sqlAnnotations.isPresent()) {
            for (AnnotationValue sql : sqlAnnotations.get()) {
                if (sql.getRequiredValue("phase", Sql.Phase.class) != phase) continue;
                List<@NonNull String> scripts = Arrays.asList(sql.stringValues());
                if (!scripts.isEmpty()) {
                    Consumer<String> proc = TestSqlAnnotationHandler.bean((Class)sql.getRequiredValue("resourceType", Class.class), (String)sql.getRequiredValue("dataSourceName", String.class), applicationContext);
                    TestSqlAnnotationHandler.handleScript(resourceLoader, scripts, proc, phase);
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("No SQL scripts found for {} phase", (Object)phase);
            }
        }
    }

    private static <T> Consumer<String> bean(Class<T> dataSourceType, String dataSourceName, ApplicationContext applicationContext) {
        Object ds = applicationContext.getBean(dataSourceType, Qualifiers.byName((String)dataSourceName));
        SqlHandler handler = (SqlHandler)applicationContext.getBean(SqlHandler.class, Qualifiers.byTypeArguments((Class[])new Class[]{dataSourceType}));
        return s -> handler.handle(ds, (String)s);
    }

    private static void handleScript(ResourceLoader loader, List<String> scripts, Consumer<String> processor, Sql.Phase phase) throws IOException {
        for (String script : scripts) {
            Optional resource = loader.getResource(script);
            if (resource.isPresent()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing {} SQL script: {}", (Object)phase, (Object)script);
                }
                InputStream in = ((URL)resource.get()).openStream();
                try {
                    String scriptBody = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                    processor.accept(scriptBody);
                    continue;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    continue;
                }
            }
            LOG.warn("Could not find SQL script: {}", (Object)script);
        }
    }
}

