/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.testresources.buildtools;

import java.util.Objects;
import java.util.Optional;

public final class ServerSettings {
    private final int port;
    private final String accessToken;
    private final Integer clientTimeout;
    private final Integer idleTimeoutMinutes;

    @Deprecated
    public ServerSettings(int port, String accessToken, Integer clientTimeout) {
        this(port, accessToken, clientTimeout, null);
    }

    public ServerSettings(int port, String accessToken, Integer clientTimeout, Integer idleTimeoutMinutes) {
        this.port = port;
        this.accessToken = accessToken;
        this.clientTimeout = clientTimeout;
        this.idleTimeoutMinutes = idleTimeoutMinutes;
    }

    public int getPort() {
        return this.port;
    }

    public Optional<String> getAccessToken() {
        return Optional.ofNullable(this.accessToken);
    }

    public Optional<Integer> getClientTimeout() {
        return Optional.ofNullable(this.clientTimeout);
    }

    public Optional<Integer> getIdleTimeoutMinutes() {
        return Optional.ofNullable(this.idleTimeoutMinutes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerSettings that = (ServerSettings)o;
        if (this.port != that.port) {
            return false;
        }
        if (!Objects.equals(this.accessToken, that.accessToken)) {
            return false;
        }
        if (!Objects.equals(this.clientTimeout, that.clientTimeout)) {
            return false;
        }
        return Objects.equals(this.idleTimeoutMinutes, that.idleTimeoutMinutes);
    }

    public int hashCode() {
        int result = this.port;
        result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        result = 31 * result + (this.clientTimeout != null ? this.clientTimeout.hashCode() : 0);
        result = 31 * result + (this.idleTimeoutMinutes != null ? this.idleTimeoutMinutes.hashCode() : 0);
        return result;
    }
}

