/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import io.milton.common.FileUtils;
import io.milton.common.Utils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Formatter {
    private static final Logger log = LoggerFactory.getLogger(Formatter.class);
    public static final String CHECKBOX_SUFFIX = "_checkbox";
    public static ThreadLocal<DateFormat> tlSdfUkShort = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd/MM/yyyy"));
    public static ThreadLocal<DateFormat> tlSdfUkLong = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd MMMM yyyy"));
    public static final ThreadLocal<DateFormat> sdfDateOnly = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd/MM/yyyy"));
    public static final ThreadLocal<DateFormat> sdfDateAndTime = ThreadLocal.withInitial(() -> new SimpleDateFormat("dd/MM/yyyy HH:mm"));

    public String toString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public Boolean toBool(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return i == 0;
        }
        if (o instanceof String) {
            String s = (String)o;
            s = s.toLowerCase();
            if ((s = s.trim()).length() > 0) {
                return s.equals("true") || s.equals("yes");
            }
            return null;
        }
        throw new RuntimeException("Unsupported boolean type: " + o.getClass());
    }

    public BigDecimal toDecimal(Object o, int places) {
        if (o == null) {
            return BigDecimal.ZERO;
        }
        if (o instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)o;
            return bd.setScale(places, RoundingMode.HALF_UP);
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            return BigDecimal.valueOf(d).setScale(places, RoundingMode.HALF_UP);
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return BigDecimal.valueOf(i.longValue()).setScale(places, RoundingMode.HALF_UP);
        }
        if (o instanceof Float) {
            Float f = (Float)o;
            return BigDecimal.valueOf(f.doubleValue()).setScale(places, RoundingMode.HALF_UP);
        }
        if (o instanceof String) {
            String s = (String)o;
            if ((s = s.trim()).length() == 0) {
                return BigDecimal.ZERO;
            }
            try {
                return new BigDecimal(s).setScale(places, RoundingMode.HALF_UP);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Non-numeric data: " + s);
            }
        }
        throw new RuntimeException("Unsupported value type, should be numeric: " + o.getClass());
    }

    public Double toDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof String) {
            String s = (String)o;
            if ((s = s.trim()).length() == 0) {
                return 0.0;
            }
            try {
                return Double.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Non-numeric data: " + s);
            }
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            return (double)i;
        }
        if (o instanceof Float) {
            Float f = (Float)o;
            return f.doubleValue();
        }
        if (o instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)o;
            return bd.doubleValue();
        }
        throw new RuntimeException("Unsupported value type, should be numeric: " + o.getClass());
    }

    public Long toLong(Object oLimit) {
        return this.toLong(oLimit, false);
    }

    public Long toLong(Object oVal, boolean withNulls) {
        Long limit;
        if (oVal == null) {
            limit = withNulls ? null : Long.valueOf(0L);
        } else if (oVal instanceof Long) {
            limit = (Long)oVal;
        } else if (oVal instanceof Integer) {
            int i = (Integer)oVal;
            limit = i;
        } else {
            if (oVal instanceof Double) {
                Double d = (Double)oVal;
                return d.longValue();
            }
            if (oVal instanceof Float) {
                Float d = (Float)oVal;
                return d.longValue();
            }
            if (oVal instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)oVal;
                return bd.longValue();
            }
            if (oVal instanceof Boolean) {
                Boolean bb = (Boolean)oVal;
                return bb != false ? 1L : 0L;
            }
            if (oVal instanceof String) {
                String s = (String)oVal;
                if (s.length() == 0) {
                    limit = withNulls ? null : Long.valueOf(0L);
                } else {
                    if (s.equals("true") || s.equals("false")) {
                        Boolean b = Boolean.parseBoolean(s);
                        return this.toLong(b);
                    }
                    if (s.contains(".")) {
                        Double d = this.toDouble(s);
                        limit = d.longValue();
                    } else {
                        limit = Long.parseLong(s);
                    }
                }
            } else {
                throw new RuntimeException("unsupported class: " + oVal.getClass());
            }
        }
        return limit;
    }

    public int getYear(Object o) {
        if (!(o instanceof java.util.Date)) {
            return 0;
        }
        java.util.Date dt = (java.util.Date)o;
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(1);
    }

    public int getMonth(Object o) {
        if (!(o instanceof java.util.Date)) {
            return 0;
        }
        java.util.Date dt = (java.util.Date)o;
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(2) + 1;
    }

    public int getDayOfMonth(Object o) {
        if (!(o instanceof java.util.Date)) {
            return 0;
        }
        java.util.Date dt = (java.util.Date)o;
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        return cal.get(5) + 1;
    }

    public String formatMinsAsDuration(Object o) {
        return this.formatMinsAsDuration(o, true);
    }

    public String formatMinsAsDuration(Object o, boolean numeric) {
        Long l = this.toLong(o);
        if (l == null) {
            return "";
        }
        if (l == 0L) {
            return "";
        }
        long hours = l / 60L;
        long mins = l % 60L;
        if (numeric) {
            return hours + ":" + this.pad(mins, 2);
        }
        if (hours == 0L) {
            return mins + "mins";
        }
        if (hours == 1L) {
            return hours + "hr " + mins;
        }
        return hours + "hrs " + mins;
    }

    public String pad2(long l) {
        return this.pad(l, 2);
    }

    public String pad(long l, int length) {
        return this.padWith("0", l, length);
    }

    public String padWith(String padChar, long l, int length) {
        return this._pad(padChar, l + "", length);
    }

    private String _pad(String padChar, String val, int length) {
        if (val.length() >= length) {
            return val;
        }
        return this._pad(padChar, padChar + val, length);
    }

    public String toPercent(Object num, Object div) {
        return this.toPercent(num, div, true, true);
    }

    public String toPercent(Object num, Object div, boolean appendSymbol, boolean withBlanks) {
        Long lNum = this.toLong(num, true);
        Long lDiv = this.toLong(div, true);
        if (lDiv == null || lDiv == 0L || lNum == null) {
            if (withBlanks) {
                return "";
            }
            return "0" + (appendSymbol ? "%" : "");
        }
        long perc = lNum * 100L / lDiv;
        return perc + (appendSymbol ? "%" : "");
    }

    public String stripExt(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        return FileUtils.stripExtension(s);
    }

    public boolean gt(Object val1, Object val2) {
        if (val1 == null) {
            return false;
        }
        if (val2 == null) {
            return true;
        }
        Double d1 = this.toDouble(val1);
        Double d2 = this.toDouble(val2);
        return d1 > d2;
    }

    public boolean lt(Object val1, Object val2) {
        if (val1 == null) {
            return false;
        }
        if (val2 == null) {
            return true;
        }
        Double d1 = this.toDouble(val1);
        Double d2 = this.toDouble(val2);
        return d1 < d2;
    }

    public boolean eq(Object val1, Object val2) {
        Double d2;
        if (val1 == null) {
            return val2 == null;
        }
        if (val2 == null) {
            return false;
        }
        Double d1 = this.toDouble(val1);
        return d1 == (d2 = this.toDouble(val2));
    }

    public String percentDecode(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() == 0) {
            return "";
        }
        return Utils.decodePath(s);
    }

    public String percentEncode(String s) {
        if (s == null) {
            return null;
        }
        return Utils.percentEncode(s);
    }

    public java.util.Date toDate(Object oVal) {
        if (oVal == null) {
            return null;
        }
        if (oVal instanceof java.util.Date) {
            return (java.util.Date)oVal;
        }
        if (oVal instanceof String) {
            String s = (String)oVal;
            return this.parseDate(s);
        }
        return null;
    }

    public Date toSqlDate(Object oVal) {
        java.util.Date dt = this.toDate(oVal);
        if (dt == null) {
            return null;
        }
        return new Date(dt.getTime());
    }

    public Timestamp toSqlTimestamp(Object oVal) {
        java.util.Date dt = this.toDate(oVal);
        if (dt == null) {
            return null;
        }
        return new Timestamp(dt.getTime());
    }

    public String toPlain(String html) {
        if (html == null) {
            return null;
        }
        html = this.replaceTag("br", html, "", "\n");
        html = this.replaceTag("p", html, "", "\n");
        html = this.replaceTag("b", html, "", "");
        html = this.replaceTag("i", html, "", "");
        html = this.replaceTag("h1", html, "", "");
        html = this.replaceTag("h2", html, "", "");
        html = this.replaceTag("h3", html, "", "");
        return html;
    }

    private String replaceTag(String tag, String html, String replaceWithOpening, String replaceWithClosing) {
        html = html.replace("<" + tag + "/>", replaceWithClosing);
        html = html.replace("<" + tag + ">", replaceWithOpening);
        html = html.replace("</" + tag + ">", replaceWithClosing);
        return html;
    }

    public String getMonthName(int i) {
        switch (i) {
            case 0: {
                return "January";
            }
            case 1: {
                return "February";
            }
            case 2: {
                return "March";
            }
            case 3: {
                return "April";
            }
            case 4: {
                return "May";
            }
            case 5: {
                return "June";
            }
            case 6: {
                return "July";
            }
            case 7: {
                return "August";
            }
            case 8: {
                return "September";
            }
            case 9: {
                return "October";
            }
            case 10: {
                return "November";
            }
            case 11: {
                return "December";
            }
        }
        return "Unknown month " + i;
    }

    public String ifEqual(String ifEqual, String ifNoteEqual, Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? ifEqual : ifNoteEqual;
        }
        return o1.equals(o2) ? ifEqual : ifNoteEqual;
    }

    public Object ifTrue(Object bb, Object o1, Object o2) {
        Boolean b = this.toBool(bb);
        if (b == null) {
            b = Boolean.FALSE;
        }
        return b != false ? o1 : o2;
    }

    private java.util.Date parseDate(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        try {
            java.util.Date dt = s.contains(":") ? this.sdf(true).parse(s) : this.sdf(false).parse(s);
            return dt;
        }
        catch (ParseException ex) {
            log.warn("couldnt parse date", (Throwable)ex);
            return null;
        }
    }

    public DateFormat sdf(boolean hasTime) {
        if (hasTime) {
            return sdfDateAndTime.get();
        }
        return sdfDateOnly.get();
    }

    public BigDecimal toBigDecimal(Object o, int decimals) {
        if (o instanceof Integer) {
            Integer ii = (Integer)o;
            return new BigDecimal(ii);
        }
        if (o instanceof Double) {
            Double dd = (Double)o;
            return new BigDecimal(dd).setScale(decimals, RoundingMode.HALF_UP);
        }
        if (o instanceof Float) {
            Float ff = (Float)o;
            return new BigDecimal(ff.floatValue());
        }
        if (o instanceof String) {
            Double dd = this.toDouble(o);
            return this.toBigDecimal(dd, decimals);
        }
        log.warn("unhandled type: " + o.getClass());
        return null;
    }

    public String checkbox(String name, Object oChecked) {
        return this.checkbox(null, name, oChecked, "true");
    }

    public String checkbox(String id, String name, Object oChecked) {
        return this.checkbox(id, name, oChecked, "true");
    }

    public String checkbox(String id, String name, Object oChecked, String value) {
        Boolean checked = this.toBool(oChecked);
        if (checked == null) {
            checked = Boolean.FALSE;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<input type='hidden' value='' name='").append(name).append(CHECKBOX_SUFFIX).append("'/>");
        sb.append("<input type=\"checkbox\"");
        sb.append(" name=\"").append(name).append("\" ");
        if (checked.booleanValue()) {
            sb.append("checked=\"true\"");
        }
        this.appendValue(sb, value);
        if (id != null) {
            sb.append(" id=\"").append(id).append("\"");
        }
        sb.append(" />");
        return sb.toString();
    }

    public String radio(String id, String name, Object oChecked, String value) {
        Boolean checked = this.toBool(oChecked);
        if (checked == null) {
            checked = Boolean.FALSE;
        }
        StringBuilder sb = new StringBuilder("<input type=\"radio\"");
        sb.append(" name=\"").append(name).append("\"");
        if (checked.booleanValue()) {
            sb.append(" checked=\"true\"");
        }
        this.appendValue(sb, value);
        if (id != null) {
            sb.append(" id=\"").append(id).append("\"");
        }
        sb.append(" />");
        return sb.toString();
    }

    public String option(Object value, String text, Object currentValue) {
        StringBuilder sb = new StringBuilder("<option");
        this.appendValue(sb, value);
        if (currentValue != null && currentValue.equals(value)) {
            sb.append("selected=\"true\"");
        }
        sb.append(">");
        sb.append(text).append("</option>");
        return sb.toString();
    }

    private void appendValue(StringBuilder sb, Object value) {
        sb.append(" value=");
        sb.append("\"");
        if (value != null) {
            sb.append(value.toString());
        }
        sb.append("\"");
    }

    public String toCsv(Iterable list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            for (Object o : list) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(o.toString());
            }
        }
        return sb.toString();
    }

    public String toCsv(String[] list) {
        StringBuilder sb = new StringBuilder();
        if (list != null) {
            for (String o : list) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(o.toString());
            }
        }
        return sb.toString();
    }

    public java.util.Date addDays(java.util.Date now, int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(6, days);
        return cal.getTime();
    }
}

