/*
 * Decompiled with CFR 0.152.
 */
package io.milton.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JsonResult {
    public static String CONTENT_TYPE = "application/json; charset=utf-8";
    private boolean status;
    private String nextHref;
    private List<String> messages;
    private List<FieldMessage> fieldMessages;
    private Object data;

    public static JsonResult error(String description) {
        return new JsonResult(false, description);
    }

    public static JsonResult fieldError(String field, String fieldMessage) {
        JsonResult r = new JsonResult(false, "Validation error");
        r.addFieldMessage(field, fieldMessage);
        return r;
    }

    public static JsonResult returnData(String href, Object data) {
        JsonResult r = new JsonResult(true);
        r.setData(data);
        r.setNextHref(href);
        return r;
    }

    public static JsonResult returnData(Object data) {
        JsonResult r = new JsonResult(true);
        r.setData(data);
        return r;
    }

    public JsonResult() {
    }

    public JsonResult(boolean status, String nextHref, List<String> messages, List<FieldMessage> fieldMessages) {
        this.status = status;
        this.nextHref = nextHref;
        this.messages = messages;
        this.fieldMessages = fieldMessages;
    }

    public JsonResult(boolean status) {
        this.status = status;
    }

    public JsonResult(boolean status, String message) {
        this.status = status;
        this.messages = Collections.singletonList(message);
    }

    public JsonResult(boolean status, String message, String nextHref) {
        this.status = status;
        this.nextHref = nextHref;
        this.messages = Collections.singletonList(message);
    }

    public void addFieldMessage(String field, String message) {
        if (this.fieldMessages == null) {
            this.fieldMessages = new ArrayList<FieldMessage>();
        }
        this.fieldMessages.add(new FieldMessage(field, message));
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getNextHref() {
        return this.nextHref;
    }

    public void setNextHref(String nextHref) {
        this.nextHref = nextHref;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public List<FieldMessage> getFieldMessages() {
        return this.fieldMessages;
    }

    public void setFieldMessages(List<FieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public static class FieldMessage {
        private String field;
        private String message;

        public FieldMessage() {
        }

        public FieldMessage(String field, String message) {
            this.field = field;
            this.message = message;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

