/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.response;

import io.milvus.exception.ParamException;
import io.milvus.grpc.CollectionSchema;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.FieldSchema;
import io.milvus.param.ParamUtils;
import io.milvus.param.collection.FieldType;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class DescCollResponseWrapper {
    private final DescribeCollectionResponse response;

    public DescCollResponseWrapper(@NonNull DescribeCollectionResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.response = response;
    }

    public boolean getEnableDynamicField() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getEnableDynamicField();
    }

    public String getCollectionName() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getName();
    }

    public String getCollectionDescription() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getDescription();
    }

    public long getCollectionID() {
        return this.response.getCollectionID();
    }

    public int getShardNumber() {
        return this.response.getShardsNum();
    }

    public long getCreatedUtcTimestamp() {
        return this.response.getCreatedUtcTimestamp();
    }

    public List<String> getAliases() {
        ArrayList<String> aliases = new ArrayList<String>();
        for (int i = 0; i < this.response.getAliasesCount(); ++i) {
            aliases.add(this.response.getAliases(i));
        }
        return aliases;
    }

    public List<FieldType> getFields() {
        ArrayList<FieldType> results = new ArrayList<FieldType>();
        CollectionSchema schema = this.response.getSchema();
        List<FieldSchema> fields = schema.getFieldsList();
        fields.forEach(field -> results.add(ParamUtils.ConvertField(field)));
        return results;
    }

    public FieldType getFieldByName(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (fieldName.compareTo(field.getName()) != 0) continue;
            return ParamUtils.ConvertField(field);
        }
        return null;
    }

    public boolean isDynamicFieldEnabled() {
        CollectionSchema schema = this.response.getSchema();
        return schema.getEnableDynamicField();
    }

    public FieldType getPartitionKeyField() {
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (!field.getIsPartitionKey()) continue;
            return ParamUtils.ConvertField(field);
        }
        return null;
    }

    public FieldType getPrimaryField() {
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (!field.getIsPrimaryKey()) continue;
            return ParamUtils.ConvertField(field);
        }
        throw new ParamException("No primary key found.");
    }

    public FieldType getVectorField() {
        CollectionSchema schema = this.response.getSchema();
        for (int i = 0; i < schema.getFieldsCount(); ++i) {
            FieldSchema field = schema.getFields(i);
            if (field.getDataType() != DataType.FloatVector && field.getDataType() != DataType.BinaryVector) continue;
            return ParamUtils.ConvertField(field);
        }
        throw new ParamException("No vector key found.");
    }

    public String toString() {
        return "Collection Description{name:'" + this.getCollectionName() + '\'' + ", description:'" + this.getCollectionDescription() + '\'' + ", id:" + this.getCollectionID() + ", shardNumber:" + this.getShardNumber() + ", createdUtcTimestamp:" + this.getCreatedUtcTimestamp() + ", aliases:" + this.getAliases().toString() + ", fields:" + this.getFields().toString() + ", isDynamicFieldEnabled:" + this.isDynamicFieldEnabled() + '}';
    }
}

