/*
 * Decompiled with CFR 0.152.
 */
package io.moderne.java.spring.boot3;

import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationAttribute;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.trait.Annotated;
import org.openrewrite.java.trait.Traits;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.trait.VisitFunction;

public class MigrateEndpointAnnotationAccessValueSpring34
extends Recipe {
    private final String ENDPOINT_FQN = "org.springframework.boot.actuate.endpoint.annotation.Endpoint";
    private final String ACCESS_FQN = "org.springframework.boot.actuate.endpoint.Access";
    private final String READ_ONLY_VALUE = "Access.READ_ONLY";
    private final String NONE_VALUE = "Access.NONE";

    public String getDisplayName() {
        return "Migrate `@Endpoint`s `defaultAccess` value";
    }

    public String getDescription() {
        return "Since Spring Boot 3.4 the `@Endpoint` access configuration values are no longer `true|false` but `none|read-only|unrestricted`";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.springframework.boot.actuate.endpoint.annotation.Endpoint", Boolean.valueOf(false)), (TreeVisitor)new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                tree = Traits.annotated((String)"@org.springframework.boot.actuate.endpoint.annotation.Endpoint(enableByDefault=false)").asVisitor((VisitFunction)new AddAccessValue("Access.NONE")).visit(tree, (Object)ctx);
                tree = Traits.annotated((String)"@org.springframework.boot.actuate.endpoint.annotation.Endpoint(enableByDefault=true)").asVisitor((VisitFunction)new AddAccessValue("Access.READ_ONLY")).visit(tree, (Object)ctx);
                tree = new RemoveAnnotationAttribute("org.springframework.boot.actuate.endpoint.annotation.Endpoint", "enableByDefault").getVisitor().visit(tree, (Object)ctx);
                tree = new AddImport("org.springframework.boot.actuate.endpoint.Access", null, true).visit(tree, (Object)ctx);
                return super.visit(tree, (Object)ctx);
            }
        });
    }

    class AddAccessValue
    implements VisitFunction<Annotated> {
        private final String argumentSuffix;

        public AddAccessValue(String value) {
            this.argumentSuffix = String.format("defaultAccess=%s", value);
        }

        public Tree visit(Annotated annotated) {
            if (this.hasDefaultAccessAttribute(annotated)) {
                return annotated.getTree();
            }
            StringBuffer sb = new StringBuffer();
            for (Expression argument : ((J.Annotation)annotated.getTree()).getArguments()) {
                if (!(argument instanceof J.Assignment)) continue;
                J.Assignment assignment = (J.Assignment)argument;
                sb.append(((J.Identifier)assignment.getVariable()).getSimpleName());
                sb.append("=");
                sb.append(this.maybeQuote(assignment.getAssignment()));
                sb.append(",");
            }
            sb.append(this.argumentSuffix);
            return JavaTemplate.builder((String)sb.toString()).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{"package org.springframework.boot.actuate.endpoint;\npublic enum Access { NONE, READ_ONLY, UNRESTRICTED }"})).imports(new String[]{"org.springframework.boot.actuate.endpoint.Access"}).build().apply(annotated.getCursor(), ((J.Annotation)annotated.getTree()).getCoordinates().replaceArguments(), new Object[0]);
        }

        private boolean hasDefaultAccessAttribute(Annotated annotated) {
            for (Expression argument : ((J.Annotation)annotated.getTree()).getArguments()) {
                J.Assignment assignment;
                String simpleName;
                if (!(argument instanceof J.Assignment) || !"defaultAccess".equals(simpleName = ((J.Identifier)(assignment = (J.Assignment)argument).getVariable()).getSimpleName())) continue;
                return true;
            }
            return false;
        }

        private String maybeQuote(Expression assignment) {
            boolean isString = TypeUtils.isOfClassType((JavaType)assignment.getType(), (String)"String");
            return isString ? "\"" + assignment + "\"" : assignment.toString();
        }
    }
}

