/*
 * Decompiled with CFR 0.152.
 */
package io.mongock.runner.spring.base.context;

import io.mongock.runner.core.executor.dependency.DependencyContext;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class SpringDependencyContext
implements DependencyContext {
    private final ApplicationContext springContext;

    public SpringDependencyContext(ApplicationContext springContext) {
        this.springContext = springContext;
    }

    public ApplicationContext getSpringContext() {
        return this.springContext;
    }

    public <T> Optional<T> getBean(Class<T> type) {
        try {
            return Optional.ofNullable(this.springContext.getBean(type));
        }
        catch (BeansException ex) {
            return Optional.empty();
        }
    }

    public Optional<Object> getBean(String name) {
        try {
            return Optional.ofNullable(this.springContext.getBean(name));
        }
        catch (BeansException ex) {
            return Optional.empty();
        }
    }
}

