package io.mongock.utils;

import java.util.Objects;

public class Pair<F, S> {

  private F first;
  private S second;

  public Pair(F first, S second) {
    this.first = first;
    this.second = second;
  }

  public F getFirst() {
    return first;
  }

  public S getSecond() {
    return second;
  }

  public void setFirst(F first) {
    this.first = first;
  }

  public void setSecond(S second) {
    this.second = second;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (!(o instanceof Pair)) return false;
    Pair<?, ?> pair = (Pair<?, ?>) o;
    return getFirst().equals(pair.getFirst()) && getSecond().equals(pair.getSecond());
  }

  @Override
  public int hashCode() {
    return Objects.hash(getFirst(), getSecond());
  }
}
