/*
 * Decompiled with CFR 0.152.
 */
package monix.reactive.subjects;

import monix.execution.Cancelable;
import monix.execution.ChannelType;
import monix.execution.Scheduler;
import monix.execution.cancelables.SingleAssignCancelable;
import monix.execution.cancelables.SingleAssignCancelable$;
import monix.reactive.MulticastStrategy;
import monix.reactive.MulticastStrategy$Async$;
import monix.reactive.MulticastStrategy$Publish$;
import monix.reactive.OverflowStrategy;
import monix.reactive.OverflowStrategy$Unbounded$;
import monix.reactive.observers.Subscriber$;
import monix.reactive.observers.Subscriber$Extensions$;
import monix.reactive.subjects.AsyncSubject$;
import monix.reactive.subjects.BehaviorSubject$;
import monix.reactive.subjects.ConcurrentSubject;
import monix.reactive.subjects.PublishSubject$;
import monix.reactive.subjects.PublishToOneSubject$;
import monix.reactive.subjects.ReplaySubject$;
import monix.reactive.subjects.Subject;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.MatchError;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;

public final class ConcurrentSubject$
implements Serializable {
    public static ConcurrentSubject$ MODULE$;

    static {
        new ConcurrentSubject$();
    }

    public <A> ConcurrentSubject<A, A> apply(MulticastStrategy<A> multicast, Scheduler s) {
        return this.apply(multicast, OverflowStrategy$Unbounded$.MODULE$, s);
    }

    public <A> ConcurrentSubject<A, A> apply(MulticastStrategy<A> multicast, OverflowStrategy.Synchronous<A> overflow, Scheduler s) {
        ConcurrentSubject<A, A> concurrentSubject;
        MulticastStrategy<A> multicastStrategy = multicast;
        if (MulticastStrategy$Publish$.MODULE$.equals(multicastStrategy)) {
            concurrentSubject = this.publish(overflow, s);
        } else if (multicastStrategy instanceof MulticastStrategy.Behavior) {
            MulticastStrategy.Behavior behavior = (MulticastStrategy.Behavior)multicastStrategy;
            Object initial = behavior.initial();
            concurrentSubject = this.behavior(initial, overflow, s);
        } else if (MulticastStrategy$Async$.MODULE$.equals(multicastStrategy)) {
            concurrentSubject = this.async(s);
        } else if (multicastStrategy instanceof MulticastStrategy.Replay) {
            MulticastStrategy.Replay replay = (MulticastStrategy.Replay)multicastStrategy;
            Seq initial = replay.initial();
            concurrentSubject = this.replay(initial, overflow, s);
        } else if (multicastStrategy instanceof MulticastStrategy.ReplayLimited) {
            MulticastStrategy.ReplayLimited replayLimited = (MulticastStrategy.ReplayLimited)multicastStrategy;
            int capacity = replayLimited.capacity();
            Seq initial = replayLimited.initial();
            concurrentSubject = this.replayLimited(capacity, initial, overflow, s);
        } else {
            throw new MatchError(multicastStrategy);
        }
        return concurrentSubject;
    }

    public <I, O> ConcurrentSubject<I, O> from(Subject<I, O> p, OverflowStrategy.Synchronous<I> overflowStrategy, ChannelType.ProducerSide producerType, Scheduler s) {
        return new ConcurrentSubject.SubjectAsConcurrent<I, O>(p, overflowStrategy, producerType, s);
    }

    public <I, O> ChannelType.ProducerSide from$default$3() {
        return ChannelType.MultiProducer$.MODULE$;
    }

    public <A> ConcurrentSubject<A, A> publish(Scheduler s) {
        return this.from(PublishSubject$.MODULE$.apply(), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> publish(OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(PublishSubject$.MODULE$.apply(), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> publishToOne(Scheduler s) {
        return this.from(PublishToOneSubject$.MODULE$.apply(), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> publishToOne(OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(PublishToOneSubject$.MODULE$.apply(), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> behavior(A initial, Scheduler s) {
        return this.from(BehaviorSubject$.MODULE$.apply(initial), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> behavior(A initial, OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(BehaviorSubject$.MODULE$.apply(initial), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> async(Scheduler s) {
        return new ConcurrentSubject.ConcurrentAsyncSubject(AsyncSubject$.MODULE$.apply());
    }

    public <A> ConcurrentSubject<A, A> replay(Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.apply(Nil$.MODULE$), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replay(OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.apply(Nil$.MODULE$), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replay(Seq<A> initial, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.apply(initial), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replay(Seq<A> initial, OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.apply(initial), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replayLimited(int capacity, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.createLimited(capacity), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replayLimited(int capacity, OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.createLimited(capacity), strategy, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replayLimited(int capacity, Seq<A> initial, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.createLimited(capacity, initial), OverflowStrategy$Unbounded$.MODULE$, this.from$default$3(), s);
    }

    public <A> ConcurrentSubject<A, A> replayLimited(int capacity, Seq<A> initial, OverflowStrategy.Synchronous<A> strategy, Scheduler s) {
        return this.from(ReplaySubject$.MODULE$.createLimited(capacity, initial), strategy, this.from$default$3(), s);
    }

    public <I, O> Processor<I, O> toReactiveProcessor(ConcurrentSubject<I, O> source, int bufferSize, Scheduler s) {
        return new Processor<I, O>(source, s, bufferSize){
            private final Subscriber<I> subscriber;
            private final ConcurrentSubject source$1;
            private final Scheduler s$1;

            public void subscribe(Subscriber<? super O> subscriber) {
                SingleAssignCancelable sub = SingleAssignCancelable$.MODULE$.apply();
                sub.$colon$eq(this.source$1.unsafeSubscribeFn(Subscriber$.MODULE$.fromReactiveSubscriber(subscriber, (Cancelable)sub, this.s$1)));
            }

            public void onSubscribe(Subscription s) {
                this.subscriber.onSubscribe(s);
            }

            public void onNext(I t) {
                this.subscriber.onNext(t);
            }

            public void onError(Throwable t) {
                this.subscriber.onError(t);
            }

            public void onComplete() {
                this.subscriber.onComplete();
            }
            {
                this.source$1 = source$1;
                this.s$1 = s$1;
                this.subscriber = Subscriber$Extensions$.MODULE$.toReactive$extension1(Subscriber$.MODULE$.Extensions(Subscriber$.MODULE$.apply(source$1, s$1)), bufferSize$1);
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ConcurrentSubject$() {
        MODULE$ = this;
    }
}

