/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.AbstractEventExecutorGroup;
import io.netty.util.concurrent.DefaultExecutorServiceFactory;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ExecutorServiceFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.concurrent.Promise;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class MultithreadEventExecutorGroup
extends AbstractEventExecutorGroup {
    private final EventExecutor[] children;
    private final Set<EventExecutor> readonlyChildren;
    private final AtomicInteger childIndex = new AtomicInteger();
    private final AtomicInteger terminatedChildren = new AtomicInteger();
    private final Promise<?> terminationFuture = new DefaultPromise(GlobalEventExecutor.INSTANCE);
    private final EventExecutorChooser chooser;

    protected MultithreadEventExecutorGroup(int nEventExecutors, ExecutorServiceFactory executorServiceFactory, Object ... args) {
        this(nEventExecutors, (Executor)(executorServiceFactory != null ? executorServiceFactory.newExecutorService(nEventExecutors) : null), true, args);
    }

    protected MultithreadEventExecutorGroup(int nEventExecutors, Executor executor, Object ... args) {
        this(nEventExecutors, executor, false, args);
    }

    private MultithreadEventExecutorGroup(int nEventExecutors, Executor executor, boolean shutdownExecutor, Object ... args) {
        if (nEventExecutors <= 0) {
            throw new IllegalArgumentException(String.format("nEventExecutors: %d (expected: > 0)", nEventExecutors));
        }
        if (executor == null) {
            executor = this.newDefaultExecutorService(nEventExecutors);
            shutdownExecutor = true;
        }
        this.children = new EventExecutor[nEventExecutors];
        this.chooser = MultithreadEventExecutorGroup.isPowerOfTwo(this.children.length) ? new PowerOfTwoEventExecutorChooser() : new GenericEventExecutorChooser();
        for (int i = 0; i < nEventExecutors; ++i) {
            boolean success = false;
            try {
                this.children[i] = this.newChild(executor, args);
                success = true;
                continue;
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to create a child event loop", e);
            }
            finally {
                if (!success) {
                    int j;
                    for (j = 0; j < i; ++j) {
                        this.children[j].shutdownGracefully();
                    }
                    for (j = 0; j < i; ++j) {
                        EventExecutor e = this.children[j];
                        try {
                            while (!e.isTerminated()) {
                                e.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
                            }
                            continue;
                        }
                        catch (InterruptedException interrupted) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
            }
        }
        final boolean shutdownExecutor0 = shutdownExecutor;
        final Executor executor0 = executor;
        FutureListener<Object> terminationListener = new FutureListener<Object>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                if (MultithreadEventExecutorGroup.this.terminatedChildren.incrementAndGet() == MultithreadEventExecutorGroup.this.children.length) {
                    MultithreadEventExecutorGroup.this.terminationFuture.setSuccess(null);
                    if (shutdownExecutor0) {
                        ((ExecutorService)executor0).shutdown();
                    }
                }
            }
        };
        for (EventExecutor e : this.children) {
            e.terminationFuture().addListener(terminationListener);
        }
        LinkedHashSet childrenSet = new LinkedHashSet(this.children.length);
        Collections.addAll(childrenSet, this.children);
        this.readonlyChildren = Collections.unmodifiableSet(childrenSet);
    }

    protected ExecutorService newDefaultExecutorService(int nEventExecutors) {
        return new DefaultExecutorServiceFactory(this.getClass()).newExecutorService(nEventExecutors);
    }

    @Override
    public EventExecutor next() {
        return this.chooser.next();
    }

    public final int executorCount() {
        return this.children.length;
    }

    @Override
    public final <E extends EventExecutor> Set<E> children() {
        return this.readonlyChildren;
    }

    protected abstract EventExecutor newChild(Executor var1, Object ... var2) throws Exception;

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        for (EventExecutor l : this.children) {
            l.shutdownGracefully(quietPeriod, timeout, unit);
        }
        return this.terminationFuture();
    }

    @Override
    public Future<?> terminationFuture() {
        return this.terminationFuture;
    }

    @Override
    @Deprecated
    public void shutdown() {
        for (EventExecutor l : this.children) {
            l.shutdown();
        }
    }

    @Override
    public boolean isShuttingDown() {
        for (EventExecutor l : this.children) {
            if (l.isShuttingDown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isShutdown() {
        for (EventExecutor l : this.children) {
            if (l.isShutdown()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isTerminated() {
        for (EventExecutor l : this.children) {
            if (l.isTerminated()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        block0: for (EventExecutor l : this.children) {
            long timeLeft;
            while ((timeLeft = deadline - System.nanoTime()) > 0L) {
                if (!l.awaitTermination(timeLeft, TimeUnit.NANOSECONDS)) continue;
                continue block0;
            }
            break block0;
        }
        return this.isTerminated();
    }

    private static boolean isPowerOfTwo(int val) {
        return (val & -val) == val;
    }

    private final class GenericEventExecutorChooser
    implements EventExecutorChooser {
        private GenericEventExecutorChooser() {
        }

        @Override
        public EventExecutor next() {
            return MultithreadEventExecutorGroup.this.children[Math.abs(MultithreadEventExecutorGroup.this.childIndex.getAndIncrement() % MultithreadEventExecutorGroup.this.children.length)];
        }
    }

    private final class PowerOfTwoEventExecutorChooser
    implements EventExecutorChooser {
        private PowerOfTwoEventExecutorChooser() {
        }

        @Override
        public EventExecutor next() {
            return MultithreadEventExecutorGroup.this.children[MultithreadEventExecutorGroup.this.childIndex.getAndIncrement() & MultithreadEventExecutorGroup.this.children.length - 1];
        }
    }

    private static interface EventExecutorChooser {
        public EventExecutor next();
    }
}

