/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.rendezvous;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.rendezvous.MsgEchoPeerHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;

public abstract class MsgEchoPeerBase {
    protected final int messageSize;
    protected final InetSocketAddress self;
    protected final InetSocketAddress peer;

    protected MsgEchoPeerBase(InetSocketAddress self, InetSocketAddress peer, int messageSize) {
        this.messageSize = messageSize;
        this.self = self;
        this.peer = peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        DefaultThreadFactory connectFactory = new DefaultThreadFactory("rendezvous");
        NioEventLoopGroup connectGroup = new NioEventLoopGroup(1, (ThreadFactory)connectFactory, NioUdtProvider.MESSAGE_PROVIDER);
        try {
            Bootstrap boot = new Bootstrap();
            ((Bootstrap)((Bootstrap)boot.group((EventLoopGroup)connectGroup)).channelFactory(NioUdtProvider.MESSAGE_RENDEZVOUS)).handler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                public void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new MsgEchoPeerHandler(MsgEchoPeerBase.this.messageSize)});
                }
            });
            ChannelFuture f = boot.connect((SocketAddress)this.peer, (SocketAddress)this.self).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            connectGroup.shutdownGracefully();
        }
    }
}

